<?
class contact_model
{
  const NO_CONTACT=0;
  const RCD_SENT  =1;
  const RCD_RCVD  =2;
  const IN_CONTACT=3;
  const IS_SELF   =4;

  private $db;

  /**
   * constructor
   *
   * @param object $db
   */
  public function __construct($db)
  {
    $this->db = $db;
  }

  /**
   * destructor
   *
   */
  public function __destruct()
  {
  }

  /**
   * set status
   *
   * @param int $uid - UID of actual user
   * @param array $contact_uids - UIDs of contact user
   * @param int $status 
   */
  public function set_contact_status($uid, array $contact_uids, $old_status, $new_status)
  {
    $tmp_tab = $this->db->get_temp_table_name();
    if(!$this->db->execute("CREATE TEMPORARY TABLE ".$tmp_tab." SELECT ".$uid." AS uid, uid AS contact_uid, 0 AS status FROM users WHERE uid IN(".implode(",", $contact_uids).")"))
      return false;

    if(!$this->db->execute("UPDATE ".$tmp_tab." t, user_contacts u SET t.status=u.status WHERE u.uid=".$uid." AND t.contact_uid=u.contact_uid"))
      return false;

    if(!$this->db->execute("DELETE FROM ".$tmp_tab." WHERE status!=".$old_status))
      return false;

    if(!$this->db->execute("DELETE FROM user_contacts u USING user_contacts u, ".$tmp_tab." t WHERE u.uid=".$uid." AND u.contact_uid=t.contact_uid"))
      return false;

    if(!$this->db->execute("INSERT INTO user_contacts SELECT uid, contact_uid, ".$new_status." FROM ".$tmp_tab))
      return false;

    $this->db->drop_table($tmp_tab);

    return true;
  }

  /**
   * set status
   *
   * @param int $uid - UID of actual user
   * @param array $contact_uids - UIDs of contact user
   * @param int $status 
   */
  public function set_user_contacts_status($uid, array $contact_uids, $old_status, $new_status)
  {
    $tmp_tab = $this->db->get_temp_table_name();
    if(!$this->db->execute("CREATE TEMPORARY TABLE ".$tmp_tab." SELECT uid, ".$uid." AS contact_uid, 0 AS status FROM users WHERE uid IN(".implode(",", $contact_uids).")"))
      return false;

    if(!$this->db->execute("UPDATE ".$tmp_tab." t, user_contacts u SET t.status=u.status WHERE u.uid=t.uid AND u.contact_uid=".$uid))
      return false;

    if(!$this->db->execute("DELETE FROM ".$tmp_tab." WHERE status!=".$old_status))
      return false;

    if(!$this->db->execute("DELETE FROM user_contacts u USING user_contacts u, ".$tmp_tab." t WHERE u.uid=t.uid AND u.contact_uid=".$uid))
      return false;

    if(!$this->db->execute("INSERT INTO user_contacts SELECT uid, contact_uid, ".$new_status." FROM ".$tmp_tab))
      return false;

    $this->db->drop_table($tmp_tab);

    return true;
  }

  /**
   *
   * @param int $uid - UID of actual user
   */
  public function get_contacts_by_uid($uid)
  {
    $contacts = array();
    $lnk = $this->db->execute("SELECT * FROM user_contacts c, users u WHERE c.uid=".$uid." AND u.uid=c.contact_uid");
    if($lnk && $this->db->num_rows($lnk))
      {
        while($data = $this->db->fetch_assoc($lnk))
          $contacts[] = $data;
      }

    return $contacts;
  }

  /**
   *
   * @param int $uid - UID of actual user
   * @param union int/array $status - contact status
   */
  public function get_contacts_by_status($uid, $status)
  {
    $contacts = array();

    if(!is_array($status))
      $status_arr[] = $status;
    else
      $status_arr = $status;

    $lnk = $this->db->execute("SELECT * FROM user_contacts c, users u WHERE c.uid=".$uid." AND c.status IN(".implode(",", $status_arr).") AND u.uid=c.contact_uid");
    if($lnk && $this->db->num_rows($lnk))
      {
        while($data = $this->db->fetch_assoc($lnk))
          $contacts[] = $data;
      }

    return $contacts;
  }

  /**
   *
   * @param int $uid - UID of actual user
   */
  public function send_rcds($uid, $contact_request_uids)
  {
    if(!$this->set_contact_status($uid, $contact_request_uids, self::NO_CONTACT, self::RCD_SENT))
      return false;

    return $this->set_user_contacts_status($uid, $contact_request_uids, self::NO_CONTACT, self::RCD_RCVD);
  }

  /**
   *
   * @param int $uid - UID of actual user
   */
  public function accept_rcds($uid, $contact_request_uids)
  {
    if(!$this->set_contact_status($uid, $contact_request_uids, self::RCD_RCVD, self::IN_CONTACT))
      return false;

    return $this->set_user_contacts_status($uid, $contact_request_uids, self::RCD_SENT, self::IN_CONTACT);
  }

  /**
   *
   * @param int $uid - UID of actual user
   */
  public function reject_rcds($uid, $contact_request_uids)
  {
    if(!$this->set_contact_status($uid, $contact_request_uids, self::RCD_RCVD, self::NO_CONTACT))
      return false;

    return $this->set_user_contacts_status($uid, $contact_request_uids, self::RCD_SENT, self::NO_CONTACT);
  }

  /**
   *
   * @param int $self_uid - UID of actual user
   * @param int $contact_uid - contact uid
   */
  public function is_contact($self_uid, $contact_uid)
  {
    $lnk = $this->db->execute("SELECT uid FROM user_contacts c WHERE c.uid=".$self_uid." AND  c.contact_uid=".$contact_uid." AND c.status = ".self::IN_CONTACT );
    if($lnk && $this->db->num_rows($lnk))
      {
        return true;
      }
    
    return false;
  }

  public static function string2int($status)
  {
    if ($status=="in_contact")
      return self::IN_CONTACT;
    if ($status=="no_contact")
      return self::NO_CONTACT;
    if ($status=="RCD_sent")
      return self::RCD_SENT;
    if ($status=="RCD_received")
      return self::RCD_RCVD;
    return NULL;
  }
}
?>
