<?php
class db_nurse
{
  protected $db;
  protected $errors;
  protected $executed_tasks;

  public function __construct(dbwrap $db)
  {
    $this->db=$db;
    $this->table_changer=new table_changer($db);

    $this->errors=array();
    $this->executed_tasks=array();
  }
  
  protected function get_field_definition($struct)
  {
    return new field_definition($struct);
  }

  public function execute_task($task)
  {
    $simple_taskname=preg_replace("/__heal_/","",$task);
    $this->errors=array();
    $this->current_task=$simple_taskname;
    $ret=$this->$task();
    if ($ret)
      $this->executed_tasks[]=$simple_taskname;
    $this->current_task=NULL;

    return $ret;
  }

  public function get_error_count()
  {
    return sizeof($this->errors);
  }

  public function get_errors()
  {
    return $this->errors;
  }
  
  public function set_executed_tasks($tasks)
  {
    $this->executed_tasks=$tasks;
  }

  function __heal_create_users()
  {
    $sth = $this->db->execute("CREATE TABLE users (
  uid int(11) NOT NULL auto_increment,
  u_account text NOT NULL default '',
  u_passwd text NOT NULL default '',
  u_ppasswd text NOT NULL default '',
  u_firstname text NOT NULL default '',
  u_name text NOT NULL default '',
  u_email text NOT NULL default '',
  u_address text NOT NULL default '',
  u_city text NOT NULL default '',
  u_country text NOT NULL default '',
  u_prim_motto text NOT NULL default '',
  u_sec_motto text NOT NULL default '',
  u_prim_ept text NOT NULL default '',
  u_sec_ept text NOT NULL default '',
  u_gps text NOT NULL default '',
  u_likes text NOT NULL default '',
  u_dislikes text NOT NULL default '',
  PRIMARY KEY  (uid),
  KEY ind_account (u_account(20)),
  KEY ind_name (u_name(20)),
  KEY email (u_email(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8");

    if($sth)
      return true;

    return false;
  }

  function __heal_create_user_contacts()
  {
    $sth = $this->db->execute("CREATE TABLE user_contacts (
  uid int(11) NOT NULL,
  contact_uid int(11) NOT NULL,
  status tinyint(2) NOT NULL default '',
  PRIMARY KEY  (uid),
  KEY ind_contact_uid (contact_uid),
  KEY ind_status (status)
) ENGINE=MyISAM DEFAULT CHARSET=utf8");

    if($sth)
      return true;

    return false;
  }

  function __heal_create_user_ttt()
  {
    $sth = $this->db->execute("CREATE TABLE user_ttt (
  uid int(11) NOT NULL,
  dt_act datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  personality_type text NOT NULL default '',
  E int(11) NOT NULL, # Extroversion
  I int(11) NOT NULL, # Introversion
  N int(11) NOT NULL, # Intuition
  S int(11) NOT NULL, # Sensing
  T int(11) NOT NULL, # Thinking
  F int(11) NOT NULL, # Feeling
  J int(11) NOT NULL, # Judgement
  P int(11) NOT NULL, # Perception
  PRIMARY KEY  (uid),
  KEY ind_personality_type (personality_type(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8");

    if($sth)
      return true;

    return false;
  }

  function __heal_add_ttt_temperament()
  {
    $fielddef=$this->get_field_definition(array("fieldname"=>"kersey_temperament",
                                                "type"=>"tinyint",
                                                "size"=>"2",
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("user_ttt", $fielddef))
      return false;
    return true;
  }

  function __heal_change_ttt_uid_index()
  {
    if(!$this->db->execute("DROP INDEX `PRIMARY` ON user_ttt"))
      return false;


    if(!$this->db->execute("CREATE INDEX ind_uid ON user_ttt (uid)"))
      return false;

    return true;
  }

  function __heal_drop_ttt()
  {
    $fielddef=$this->get_field_definition(array("fieldname"=>"dt_ttt",
                                                "type"=>"datetime",
                                                "not_null"=>true,
                                                "default"=>"0000-00-00 00:00:00"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"dt_last_login",
                                                "type"=>"datetime",
                                                "not_null"=>true,
                                                "default"=>"0000-00-00 00:00:00"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"dt_last_logout",
                                                "type"=>"datetime",
                                                "not_null"=>true,
                                                "default"=>"0000-00-00 00:00:00"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"dt_register",
                                                "type"=>"datetime",
                                                "not_null"=>true,
                                                "default"=>"0000-00-00 00:00:00"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"dt_update_register",
                                                "type"=>"datetime",
                                                "not_null"=>true,
                                                "default"=>"0000-00-00 00:00:00"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"E",
                                                "type"=>"tinyint",
                                                "size" => 2,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"I",
                                                "type"=>"tinyint",
                                                "size" => 2,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"N",
                                                "type"=>"tinyint",
                                                "size" => 2,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"S",
                                                "type"=>"tinyint",
                                                "size" => 2,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;
    $fielddef=$this->get_field_definition(array("fieldname"=>"T",
                                                "type"=>"tinyint",
                                                "size" => 2,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"F",
                                                "type"=>"tinyint",
                                                "size" => 2,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"J",
                                                "type"=>"tinyint",
                                                "size" => 2,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"P",
                                                "type"=>"tinyint",
                                                "size" => 2,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"kersey_temperament",
                                                "type"=>"tinyint",
                                                "size" => 2,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    if(!$this->db->drop_table("user_ttt"))
      return false;

    return true;
  }

  function __heal_add_mbti_values()
  {
    $fielddef=$this->get_field_definition(array("fieldname"=>"E_val",
                                                "type"=>"int",
                                                "size" => 11,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"I_val",
                                                "type"=>"int",
                                                "size" => 11,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"N_val",
                                                "type"=>"int",
                                                "size" => 11,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"S_val",
                                                "type"=>"int",
                                                "size" => 11,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;
    $fielddef=$this->get_field_definition(array("fieldname"=>"T_val",
                                                "type"=>"int",
                                                "size" => 11,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"F_val",
                                                "type"=>"int",
                                                "size" => 11,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"J_val",
                                                "type"=>"int",
                                                "size" => 11,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;

    $fielddef=$this->get_field_definition(array("fieldname"=>"P_val",
                                                "type"=>"int",
                                                "size" => 11,
                                                "not_null"=>true,
                                                "default"=>"0"));
    if(!$this->table_changer->verify_field("users", $fielddef))
      return false;
  }

  public function __heal_add_cool_session_tables()
  {
    $sth=$this->db->execute("CREATE TABLE IF NOT EXISTS `survey_session` (
  `sid` binary(32) NOT NULL default '',
  `uid` int(11) default NULL,
  `fid` int(11) default NULL,
  `type` tinyint(4) default '0',
  `dt_exp` int(10) unsigned default NULL,
  PRIMARY KEY  (`sid`),
  KEY `dt_exp` (`dt_exp`),
  KEY `fid` (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED");

    if (!$sth)
      return false;
    
    $sth=$this->db->execute("CREATE TABLE IF NOT EXISTS `session_vars` (
  `sid` varbinary(32) NOT NULL default '',
  `vars` longblob,
  PRIMARY KEY  (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8");

    if (!$sth)
      return false;

    return true;
  }

  function __heal_change_contact_uid_index()
  {
    if(!$this->db->execute("DROP INDEX `PRIMARY` ON user_contacts"))
      return false;


    if(!$this->db->execute("CREATE INDEX ind_uid ON user_contacts (uid)"))
      return false;

    return true;
  }

  public function __heal_add_temp_gfx()
  {
    $sth=$this->db->execute("CREATE TABLE temp_gfx (uid int(11),gfx blob,dt int(11),PRIMARY KEY(uid),INDEX(dt))");

    if (!$sth)
      return false;

    return true;
  }

  function __heal_add_performance_index()
  {
    if(!$this->db->execute("CREATE INDEX ind_ttt ON users (E, I, N, S, T, F, J, P)"))
      return false;

    if(!$this->db->execute("CREATE INDEX ind_motto ON users (u_prim_motto(20), u_sec_motto(20))"))
      return false;

    return true;
  }
}
?>
