<?php
class graph_builder
{
  const INNER_SCALE_OFFSET=10;
  const OUTER_SCALE_OFFSET=30;
  const MARGIN            =2;
  const SCALE_LINE_HEIGHT =5;
  const SCALE_TEXT_OFFSET =2;

  const SYMBOL_CROSS   =1;
  const SYMBOL_CIRCLE  =2;
  const SYMBOL_RECT    =3;
  const SYMBOL_TRIANGLE=4;
  const SYMBOL_POINT   =5;

  const DEGREE_360=6.2831853071796;

  protected $surface;
  protected $context;
  protected $start_x;
  protected $start_y;

  protected $horizontal_scale=array();
  protected $vertical_scale=array();

  protected $horizontal_scale_step=0;
  protected $vertical_scale_step=0;

  public function __construct($width,$height)
  {
    $this->full_width =$width;
    $this->full_height=$height;
  }

  public function set_horizontal_scale(array $horiz_scale)
  {
    $this->horizontal_scale=$horiz_scale;
  }
  
  public function set_vertical_scale(array $vert_scale)
  {
    $this->vertical_scale=$vert_scale;
  }

  public function set_vertical_scale_text($vertical_scale_text)
  {
    $this->vertical_scale_text=$vertical_scale_text;
  }
  
  public function set_horizontal_scale_text($horizontal_scale_text)
  {
    $this->horizontal_scale_text=$horizontal_scale_text;
  }

  protected function draw_grid()
  {
    $this->context->rectangle($this->canvas_x,$this->canvas_y,$this->canvas_width,$this->canvas_height);
    $this->context->set_source_rgb(0,0,0);
    $this->context->stroke();
    $this->context->set_line_width(0.5);
    $this->context->set_source_rgb(0,0.5,0);
    
    if (sizeof($this->vertical_scale)>0)
    {
      foreach ($this->vertical_scale as $key => $scale_text)
      {
        $this->context->move_to($this->canvas_x,$this->plot_y+$this->vertical_scale_step*$key);
        $this->context->rel_line_to($this->canvas_width,0);
        $this->context->stroke();
      }
    }
    
    if (sizeof($this->horizontal_scale)>0)
    {
      foreach ($this->horizontal_scale as $key => $scale_text)
      {
        $this->context->move_to($this->plot_x+$this->horizontal_scale_step*$key,$this->canvas_y);
        $this->context->rel_line_to(0,$this->canvas_height);
        $this->context->stroke();
      }
    }
  }

  protected function draw_horizontal_scale()
  {
    $this->context->set_source_rgb(0,0,0);
    $this->context->set_line_width(1);

    $text_position_y=$this->canvas_y+$this->canvas_height+self::SCALE_LINE_HEIGHT+self::SCALE_TEXT_OFFSET;

    $this->context->select_font_face("Helvetica",CAIRO_FONT_SLANT_NORMAL,CAIRO_FONT_WEIGHT_NORMAL);
    $this->context->set_font_size(11);

    foreach ($this->horizontal_scale as $key => $scale_text)
    {
      $this->context->move_to($this->plot_x+$this->horizontal_scale_step*$key,$this->canvas_y+$this->canvas_height);
      $this->context->rel_line_to(0,self::SCALE_LINE_HEIGHT);
      $this->context->stroke();
      
      $extents=$this->context->text_extents($scale_text);
      $this->context->move_to($this->plot_x+$this->horizontal_scale_step*$key-$extents["width"]/2,$text_position_y+$extents["height"]);
      $this->context->show_text($scale_text);
    }

    if ($this->horizontal_scale_text)
    {
      $extents=$this->context->text_extents($this->horizontal_scale_text);
      $this->context->move_to($this->plot_x+$this->plot_width/2-$extents["width"]/2,$this->height);
      $this->context->show_text($this->horizontal_scale_text);
    }
  }

  protected function draw_vertical_scale()
  {
    $this->context->set_source_rgb(0,0,0);
    $this->context->set_line_width(1);

    foreach ($this->vertical_scale as $key => $scale_text)
    {
      $this->context->move_to($this->canvas_x-self::SCALE_LINE_HEIGHT,$this->plot_y+$this->vertical_scale_step*$key);
      $this->context->rel_line_to(self::SCALE_LINE_HEIGHT,0);
      $this->context->stroke();
    }

    $this->context->select_font_face("Helvetica",CAIRO_FONT_SLANT_NORMAL,CAIRO_FONT_WEIGHT_NORMAL);
    $this->context->set_font_size(11);

    $this->context->save();
    $this->context->translate(0,$this->canvas_y+$this->canvas_height);
    $this->context->save();
    $this->context->rotate(deg2rad(-90));

    foreach ($this->vertical_scale as $key => $scale_text)
    {
      $extents=$this->context->text_extents($scale_text);
      $this->context->move_to($this->plot_y+$this->vertical_scale_step*$key-$extents["width"]/1.2,self::OUTER_SCALE_OFFSET-self::SCALE_LINE_HEIGHT-self::SCALE_TEXT_OFFSET);
      $this->context->show_text($scale_text);
    }
    
    if ($this->vertical_scale_text)
    {
      $extents=$this->context->text_extents($this->vertical_scale_text);
      $this->context->move_to($this->plot_y+$this->plot_height/2-$extents["width"]/2,$extents["height"]);
      $this->context->show_text($this->vertical_scale_text);
    }

    $this->context->restore();
    $this->context->restore();
  }

  public function set_plot_values(array $plot_values)
  {
    $this->plot_values=$plot_values;
  }

  public function draw_plot()
  {
    foreach ($this->plot_values as $group_values)
    {
      $this->context->set_source_rgb($group_values["color"][0],$group_values["color"][1],$group_values["color"][2]);
      $this->context->set_line_width(2);
      
      foreach ($group_values["values"] as $value)
      {
        $this->draw_point($group_values["symbol"],$this->plot_x+$value[0]*$this->plot_width,$this->plot_y+$this->plot_height-$value[1]*$this->plot_height);
      }
    }
  }

  protected function draw_point($symbol,$x,$y)
  {
    switch($symbol)
    {
      case self::SYMBOL_CIRCLE:
        $this->context->arc($x,$y,4,0,self::DEGREE_360);
        $this->context->stroke();
        break;
      case self::SYMBOL_RECT:
        $this->context->rectangle($x-3,$y-3,6,6);
        $this->context->stroke();
        break;
      case self::SYMBOL_CROSS:
        $this->context->move_to($x-3,$y-3);
        $this->context->line_to($x+3,$y+3);
        $this->context->move_to($x-3,$y+3);
        $this->context->line_to($x+3,$y-3);
        $this->context->stroke();
        break;
      case self::SYMBOL_TRIANGLE:
        $this->context->move_to($x,$y-4);
        $this->context->line_to($x-3,$y+3);
        $this->context->line_to($x+3,$y+3);
        $this->context->close_path();
        $this->context->stroke();
        break;
      case self::SYMBOL_POINT:
        $this->context->move_to($x-4,$y);
        $this->context->line_to($x+4,$y);
        $this->context->stroke();
        $this->context->move_to($x,$y-4);
        $this->context->line_to($x,$y+4);
        $this->context->stroke();
        break;
    }
  }

  protected function generate()
  {
    $this->surface=new cairo_image_surface(CAIRO_FORMAT_ARGB32,$this->full_width,$this->full_height);
    $this->context=new cairo_context($this->surface);

    $this->start_x=self::MARGIN;
    $this->start_y=self::MARGIN;

    $this->width =$this->full_width-2*self::MARGIN;
    $this->height=$this->full_height-2*self::MARGIN;

    $this->canvas_x     =self::MARGIN+self::OUTER_SCALE_OFFSET;
    $this->canvas_y     =self::MARGIN;

    $this->canvas_width =$this->width-self::OUTER_SCALE_OFFSET;
    $this->canvas_height=$this->height-self::OUTER_SCALE_OFFSET;

    $this->plot_x       =self::MARGIN+self::INNER_SCALE_OFFSET+self::OUTER_SCALE_OFFSET;
    $this->plot_y       =self::MARGIN+self::INNER_SCALE_OFFSET;

    $this->plot_width   =$this->canvas_width-2*self::INNER_SCALE_OFFSET;
    $this->plot_height  =$this->canvas_height-2*self::INNER_SCALE_OFFSET;
    $this->context->rectangle(0,0,$this->full_width,$this->full_height);
    $this->context->set_source_rgb(1,1,1);
    $this->context->fill();
    
    if (sizeof($this->horizontal_scale)>0)
      $this->horizontal_scale_step=$this->plot_width/(sizeof($this->horizontal_scale)-1);
    if (sizeof($this->vertical_scale)>0)
    $this->vertical_scale_step=$this->plot_height/(sizeof($this->vertical_scale)-1);

    $this->draw_grid();
    $this->draw_horizontal_scale();
    $this->draw_vertical_scale();
    $this->draw_plot();
  }

  public function get_png()
  {
    $this->generate();
    $filename=filefunx::get_temp_filename();
    $this->surface->write_to_png($filename);
    $png=filefunx::get_content($filename);
    filefunx::remove_file($filename);

    return $png;
  }
}
?>
