<?php
class memberlist
{
  protected $db;
  protected $uid;
  protected $handle;
  protected $count;

  protected $where = array();

  protected $search_status;
  protected $search_ttt_type;


  public function __construct(dbwrap $db, $uid)
  {
    $this->db=$db;
    $this->uid = $uid;
    $this->contact_model = new contact_model($db);
  }

  protected function get_handle()
  {
    if (!isset($this->handle))
    {
      $this->query();
    }
    return $this->handle;
  }

  public function search_rcd_status(array $rcd_status)
  {
    if(in_array(0, $rcd_status))
      $this->where[] = "(c.status IS NULL OR c.status IN(".implode(",", $rcd_status)."))";
    else
      $this->where[] = "c.status IN(".implode(",", $rcd_status).")";
  }

  public function search_ttt_type(array $search_ttt_type)
  {
    foreach(array_keys($search_ttt_type) as $type)
      $where[] = "u.".$type."=1";

    $this->where[] = "(".implode(" OR ", $where).")";
  }

  public function search_motto($motto)
  {
    $motto = addslashes($motto);
    $this->where[] = "(u.u_prim_motto LIKE '%".$motto."%' OR u.u_sec_motto LIKE '%".$motto."%')";
  }
  
  protected function query()
  {
    $where = implode(" AND ", $this->where);

    $this->handle=$this->db->execute("SELECT DISTINCT SQL_CACHE SQL_CALC_FOUND_ROWS *,IFNULL(c.status, 0) AS status,u.uid AS uid FROM users u LEFT JOIN user_contacts c ON(c.contact_uid=u.uid AND c.uid=".$this->uid.") WHERE u.uid!=".$this->uid.($where?" AND ".$where:""));

    if (!$this->handle)
      return false;
    
    $sth=$this->db->execute("SELECT FOUND_ROWS()");
    
    if (!$sth)
      return false;

    list($this->count)=$this->db->fetch_row($sth);

    return true;
  }

  public function get_members()
  {
    $handle=$this->get_handle();

    $this->db->data_seek($handle,0);

    $members=array();
    $rcd_uids=array();

    while($data=$this->db->fetch_assoc($handle))
      {
        if(($this->uid == $data["contact_uid"]) && ($data["status"] == contact_model::RCD_SENT))
          $rcd_uids[] = $data["uid"];

        $members[]=$data;
      }

    if(sizeof($rcd_uids))
      $this->contact_model->receive_rcds($this->uid, $rcd_uids);
    
    return $members;
  }
  
  public function get_members_as_objects()
  {
    $handle=$this->get_handle();

    $this->db->data_seek($handle,0);

    $members=array();

    while($data=$this->db->fetch_assoc($handle))
      {
        $member=new Memberinfo;
        $member->from_array($data);
        $members[]=$member;
      }

    return $members;
  }

  public function get_member_subset($offset,$count)
  {
    $handle=$this->get_handle();

    $this->db->data_seek($offset);

    $members=array();
    while ($fetched_count<$count && $data=$this->db->fetch_assoc($sth))
    {
      $members[]=$data;
      $fetched_count++;
    }
  }

  public function get_uid()
  {
    return $this->uid;
  }
}
?>
