<?
class model_ttt extends model
{
  private $ttt_calculator;
  private $question_list_filename = "ttt-questions.txt";
  private $ttt_questions = array();

  /**
   * constructor
   *
   * @param object $db
   */
  public function __construct($db, $__config)
  {
    parent::__construct($db, $__config);
    $this->ttt_calculator = new ttt_calculator($this->db);
  }

  /**
   * destructor
   *
   */
  public function __destruct()
  {
  }

  /**
   * save results
   *
   * @param int $uid 
   * @param array $post_mbti_types - assoc array with MBTI-types and their posted values
   */
  public function save_ttt($uid, $post_mbti_types)
  {
    foreach((array)$post_mbti_types["questions"] as $mbti_type)
      $mbti_types[$mbti_type]++;

    return $this->ttt_calculator->save_ttt($uid, $mbti_types);
  }

  public function get_ttt_questions()
  {
    if(!sizeof($this->ttt_questions))
      {
        $filename = $this->config["install_dir"].$this->question_list_filename;
        
        if(!filefunx::file_exists($filename))
          return array();
        
        $content = filefunx::get_content($filename);
        $lines = explode("\n", $content);
        
        $q_nr = 0;
        foreach($lines as $line)
          {
            if(!strlen($line))
              {
                $q_nr++;
                continue;
              }
            
            if(preg_match("/^([EISNTFJP]){1}:(.*)/", $line, $match))
              $this->ttt_questions[$q_nr]["answers"][$match[1]] = $match[2];
            else
              $this->ttt_questions[$q_nr]["question"] = $line;
          }
      }

    return $this->ttt_questions;
  }

  public function check_ttt_form_values($values)
  {
    foreach((array)$values["questions"] as $mbti_type)
      {
        $mbti_dimension = $this->ttt_calculator->get_mbti_dimension($mbti_type);
        $mbti_counts[$mbti_dimension]++;
      }

    if(!$mbti_counts)
      return array("blubb" => "blubber");

    foreach($mbti_counts as $mbti_dimension => $n)
      {
        if($n < 5)
          return array("blubb" => "blubber");
      }
    
    return true;
  }

  public function check_ttt_wsdl_values($mbti_counts)
  {
    foreach($mbti_counts as $mbti_dimension => $n)
      {
        if($n < 5)
          return false;
      }
    return true;
  }

  public function get_mbti_types()
  {
    return $this->ttt_calculator->get_mbti_types();
  }

  public function get_test_results()
  {
    $test_results = array();

    $user_data = user_model::get_user_data($_SESSION["user"]["uid"]);

    $mbti_types = $this->get_mbti_types();

    $test_results["personality_types"] = array();
    $test_results["mbti_type_values"] = array();
    foreach($mbti_types as $mbti_type)
      {
        if($user_data[$mbti_type])
          $test_results["personality_types"][] = $mbti_type;

        $test_results["mbti_type_values"][$mbti_type] = $user_data[$mbti_type."_val"];
      }

    $test_results["mbti_test_results"] = $this->ttt_calculator->get_mbti_test_results($test_results["mbti_type_values"]);
    $test_results["kersey_temperament"] = $this->ttt_calculator->get_keirsey_temperament_text($user_data["kersey_temperament"]);

    return $test_results;
  }

  public function start()
  {
  }
}
?>
