<?php
class pbt_webservice
{
  protected $db;
  protected $config;

  public function __construct(dbwrap $db,$config)
  {
    $this->db    =$db;
    $this->config=$config;
    $this->ses_conf=array("type"=>session::TYPE_OAT,"expire"=>3600);
  }
  
  public function clearDatabase()
  {
    $tables=$this->db->get_all_table_names();
    
    foreach ($tables as $table)
      $this->db->drop_table($table);
  
    $files=filefunx::enum_files(filefunx::append_slash(session_save_path()),false,"/^sess_[0-9a-f]+$/i");

    foreach ($files as $file)
      filefunx::remove_file($file);
    
    $db_doctor=new db_doctor($this->db);
    $db_doctor->heal();
  }

  public function submitMemberinfo($sessionId,$username,$password,$fullname,$emailAddress,$town,$country,$motto1,$motto2,$likes,$dislikes,$gpsCoordinates,$enneagramtype1,$enneagramtype2)
  {
    // mop: session id has to be null...username must be unique in the system
    if (isset($sessionId))
      return NULL;

    $register=new model_register($this->db,$this->config);
    if (is_array($register->check_user(array("u_account"=>$username))))
      return NULL;

    $position=strrpos($fullname," ")+1;

    $data=array("u_account"   =>$username,
                "u_passwd"    =>$password,
                "u_firstname" =>substr($fullname,0,$position-1),
                "u_name"      =>substr($fullname,$position),
                "u_email"     =>$emailAddress,
                "u_city"      =>$town,
                "u_country"   =>$country,
                "u_prim_motto"=>$motto1,
                "u_sec_motto" =>$motto2,
                "u_likes"     =>implode("\n",$likes),
                "u_dislikes"  =>implode("\n",$dislikes),
                "u_gps"       =>$gpsCoordinates,
                "u_prim_ept"  =>$enneagramtype1,
                "u_sec_ept"   =>$enneagramtype2,
               );
    
    // mop: todo...checken
    $register->add_user($data);
    
    return NULL;
  }

  public function getMemberInfo($sessionId,$username)
  {
    if (!$this->validate_session($sessionId))
      return NULL;
    
    $userdata=user_model::get_user_data_by_account($username);

    if (!$userdata)
      return NULL;

    $memberinfo=new memberinfo;
    $memberinfo->from_array($userdata);
    return $memberinfo;
  }

  public function login($username,$password)
  {
    if (user_model::login($username,$password))
    {
      $userdata=user_model::get_user_data_by_account($username);

      $sessionid=$this->gen_session($userdata["uid"]);

      if (!$sessionid)
        return NULL;

      return $sessionid;
    }
    else
    {
      return NULL;
    }
  }

  public function logout($sessionId)
  {
    if (!$this->validate_session($sessionId))
      return NULL;

    $session=$this->get_session($sessionId);
    $session->close_user_session();

    return NULL;
  }

  public function takeTtt($sessionId,$answers)
  {
    if (!$this->validate_session($sessionId))
      return NULL;
    
    $answers=strtoupper($answers);
    $simple_answers=str_replace(" ","",$answers);

    $answer_array=array();
    $ttt_calculator=new ttt_calculator($this->db);
    $dimensions=$ttt_calculator->get_mbti_dimensions();

    $rewrite_arr=array();
    foreach ($dimensions as $dimension => $categories)
    {
      foreach ($categories as $category)
        $rewrite_arr[$category]=$dimension;
      $answer_array[$dimension]=0;
    }
    
    $answer_array=array();
    $results_array=array();
    for ($i=0;$i<strlen($simple_answers);$i++)
    {
      $answer_array[$rewrite_arr[$simple_answers[$i]]]++;
      $results_array[$simple_answers[$i]]++;
    }

    $model_ttt=new model_ttt($this->db,$this->config);
    if (!$model_ttt->check_ttt_wsdl_values($answer_array))
      return NULL;

    if (!$ttt_calculator->save_ttt($this->get_uid($sessionId),$results_array))
      return NULL;

    return NULL;
  }

  public function searchForMembers($sessionId,$noContact,$noRcdSent,$newlyRegistered,$newlyRegisteredSinceDays,$inMyCountry,$maxKilometersAway,$tttTypes,$myEnneagramType1,$myEnneagramType,$mottoContains,$minLikesShared,$minDislikesShared,$minLikesDisliked,$maxDislikesLiked)
  {
    if (!$this->validate_session($sessionId))
      return NULL;

    $memberlist=$this->get_memberlist_from_request($this->get_uid($sessionId),$noContact,$noRcdSent,$newlyRegistered,$newlyRegisteredSinceDays,$inMyCountry,$maxKilometersAway,$tttTypes,$myEnneagramType1,$myEnneagramType,$mottoContains,$minLikesShared,$minDislikesShared,$minLikesDisliked,$maxDislikesLiked);

    if (!$memberlist)
      return NULL;

    return $memberlist->get_members_as_objects();
  }

  protected function wrap_gfx_variable($variable)
  {
    $wrapper_array=array("E-I"=>ttt_calculator::MBTI_E_I,
                         "S-N"=>ttt_calculator::MBTI_S_N,
                         "T-F"=>ttt_calculator::MBTI_T_F,
                         "J-P"=>ttt_calculator::MBTI_J_P,
                        );

    return $wrapper_array[$variable];
  }

  public function searchForMembersGraphic($sessionId,$xSize,$ySize,$xVariable,$yVariable,$noContact,$noRcdSent,$newlyRegistered,$newlyRegisteredSinceDays,$inMyCountry,$maxKilometersAway,$tttTypes,$myEnneagramType1,$myEnneagramType,$mottoContains,$minLikesShared,$minDislikesShared,$minLikesDisliked,$maxDislikesLiked)
  {
    if (!$this->validate_session($sessionId))
      return NULL;
    

    $real_horiz=$this->wrap_gfx_variable($xVariable);
    $real_vert =$this->wrap_gfx_variable($yVariable);

    if (!$real_horiz || !$real_vert)
      return NULL;
    
    $memberlist=$this->get_memberlist_from_request($this->get_uid($sessionId),$noContact,$noRcdSent,$newlyRegistered,$newlyRegisteredSinceDays,$inMyCountry,$maxKilometersAway,$tttTypes,$myEnneagramType1,$myEnneagramType,$mottoContains,$minLikesShared,$minDislikesShared,$minLikesDisliked,$maxDislikesLiked);

    if (!$memberlist)
      return NULL;
    
    $plot_generator=new plot_generator($this->db,$memberlist);
    $plot_generator->set_width($xSize);
    $plot_generator->set_height($ySize);
    $png=$plot_generator->generate_plot($this->get_uid($sessionId),$real_vert,$real_horiz);
    return $png;
  }

  protected function get_memberlist_from_request($uid,$noContact,$noRcdSent,$newlyRegistered,$newlyRegisteredSinceDays,$inMyCountry,$maxKilometersAway,$tttTypes,$myEnneagramType1,$myEnneagramType,$mottoContains,$minLikesShared,$minDislikesShared,$minLikesDisliked,$maxDislikesLiked)
  {
    $memberlist=new memberlist($this->db,$uid);
    $status_arr=array();
    if ($noContact)
      $status_arr[]=contact_model::NO_CONTACT;
    if ($noRcdSent)
      $status_arr[]=contact_model::RCD_SENT;

    $memberlist->search_rcd_status($status_arr);

    if ($newlyRegistered)
      return NULL;
    
    if ($newlyRegisteredSinceDays)
      return NULL;

    if ($inMyCountry)
      return NULL;

    if ($maxKilometersAway)
      return NULL;

    if ($tttTypes)
      $memberlist->search_ttt_type($tttTypes);

    if ($myEnneagramType1)
      return NULL;
    
    if ($myEnneagramType)
      return NULL;

    if ($mottoContains)
      $memberlist->search_motto($mottoContains);

    if ($minLikesShared)
      return NULL;

    if ($minDislikesShared)
      return NULL;

    if ($minLikesDisliked)
      return NULL;

    if ($maxDislikedLiked)
      return NULL;

    return $memberlist;
  }

  public function getMemberlist($sessionId,$username,$rcdStatus)
  {
    if (!$this->validate_session($sessionId))
      return NULL;

    $userdata=user_model::get_user_data_by_account($username);

    $memberlist=new memberlist($this->db,$userdata["uid"]);
    $memberlist->search_rcd_status(array(contact_model::string2int($rcdStatus)));

    return $memberlist->get_members_as_objects();
  }
  
  public function getMemberlistGraphic($sessionId,$xSize,$ySize,$xVariable,$yVariable,$username,$rcdStatus)
  {
    if (!$this->validate_session($sessionId))
      return NULL;
    
    $userdata=user_model::get_user_data_by_account($username);

    $memberlist=new memberlist($this->db,$userdata["uid"]);
    $memberlist->search_rcd_status(array(contact_model::string2int($rcdStatus)));
    
    $real_horiz=$this->wrap_gfx_variable($xVariable);
    $real_vert =$this->wrap_gfx_variable($yVariable);

    if (!$real_horiz || !$real_vert)
      return NULL;
    
    $plot_generator=new plot_generator($this->db,$memberlist);
    $plot_generator->set_width($xSize);
    $plot_generator->set_height($ySize);
    $png=$plot_generator->generate_plot($this->get_uid($sessionId),$real_vert,$real_horiz);

    return $png;
  }

  public function sendRcd($sessionId,$username,$positive)
  {
    if (!$this->validate_session($sessionId))
      return NULL;

    $uid=$this->get_uid($sessionId);
    
    $do_stuff=array();
    $do_stuff2=array();
    foreach ($username as $name)
    {
      $userdata=user_model::get_user_data_by_account($name);
      if($userdata["uid"])
        $do_stuff[] = $userdata["uid"];
    }

    $contact_model=new contact_model($this->db,$this->config);
    if ($positive)
      $contact_model->accept_rcds($this->get_uid($sessionId),$do_stuff);
    else
      $contact_model->reject_rcds($this->get_uid($sessionId),$do_stuff);

    return NULL;
  }

  protected function validate_session($sessionid)
  {
    $session=$this->get_session($sessionid);
    return $session->validate();
  }

  protected function get_uid($session_id)
  {
    $session=$this->get_session($session_id);
    if ($session->validate())
      return (int)$session->get_uid();
    return NULL;
  }
  
  protected function get_session($session_id="")
  {
    $fid=0;
    $session=new session($this->db,$this->ses_conf,$fid,$session_id);
    return $session;
  }
  
  protected function gen_session($uid)
  {
    $obj=$this->get_session();
    if (!$obj->create_session($uid,$this->ses_conf["expire"]))
      return NULL;
    return (string)$obj->get_session_id();
  }
}
?>
