<?php
class plot_generator
{
  protected $db;
  protected $memberlist;
  protected $ttt_calculator;
  protected $graph_builder;
  protected static $scatter=array(ttt_calculator::MBTI_E_I=>0.0165,
                                  ttt_calculator::MBTI_S_N=>0.0165,
                                  ttt_calculator::MBTI_T_F=>0.0165,
                                  ttt_calculator::MBTI_J_P=>0.0165,
                                 );

  public function __construct(dbwrap $db,memberlist $memberlist)
  {
    $this->db=$db;
    $this->memberlist=$memberlist;
    $this->ttt_calculator=new ttt_calculator($this->db);
    $this->init_scatter();
  }

  protected function get_scale_text($scale_selection)
  {
    return $this->ttt_calculator->get_mbti_text($scale_selection);
  }

  protected function init_scatter()
  {
    $this->scatter=array();
  }

  public function generate_plot($uid,$vertical,$horizontal)
  {
    $graph_builder=new graph_builder($this->width,$this->height);
    $mbti_dimensions=$this->ttt_calculator->get_mbti_dimensions();
    
    $vertical_mbti_dimension  =$mbti_dimensions[$vertical];
    $horizontal_mbti_dimension=$mbti_dimensions[$horizontal];

    $graph_builder->set_horizontal_scale(array(-10,-5,0,5,10));
    $graph_builder->set_vertical_scale(array(-10,-5,0,5,10));
    
    $vertical_text  =$this->get_scale_text($vertical);
    $horizontal_text=$this->get_scale_text($horizontal);
      
    $graph_builder->set_vertical_scale_text($vertical_text);
    $graph_builder->set_horizontal_scale_text($horizontal_text);
    
    $members=$this->memberlist->get_members();
    
    $graphics_data=array();
    $graphics_data[contact_model::IS_SELF]   =array("color"=>array(0,0,1),
                                                     "values"=>array(),
                                                     "symbol"=>graph_builder::SYMBOL_CROSS,
                                                     );
    $graphics_data[contact_model::RCD_SENT]  =array("color"=>array(1,0,0),
                                                     "values"=>array(),
                                                     "symbol"=>graph_builder::SYMBOL_CIRCLE,
                                                     );
    $graphics_data[contact_model::NO_CONTACT]=array("color"=>array(0,0,0),
                                                     "values"=>array(),
                                                     "symbol"=>graph_builder::SYMBOL_RECT,
                                                     );
    $graphics_data[contact_model::IN_CONTACT]=array("color"=>array(0,1,0),
                                                     "values"=>array(),
                                                     "symbol"=>graph_builder::SYMBOL_TRIANGLE,
                                                     );
      $graphics_data[contact_model::RCD_RCVD]  =array("color"=>array(0.5,0,0.5),
                                                     "values"=>array(),
                                                     "symbol"=>graph_builder::SYMBOL_POINT,
                                                     );
    $own=user_model::get_user_data($uid);
    $own["status"]=contact_model::IS_SELF;

    $members[]=$own;

    foreach ($members as $member)
    {
      $value_horiz=($member[$horizontal_mbti_dimension[0]."_val"]-$member[$horizontal_mbti_dimension[1]."_val"]);
      $value_vert =($member[$vertical_mbti_dimension[0]."_val"]-$member[$vertical_mbti_dimension[1]."_val"]);
      
      $x_value=($value_horiz+10)/20-self::$scatter[$horizontal]+mt_rand(0,2)*self::$scatter[$horizontal];
      $y_value=($value_vert+10)/20-self::$scatter[$vertical]+mt_rand(0,2)*self::$scatter[$vertical];

      $graphics_data[$member["status"]]["values"][]=array($x_value,$y_value);
    }
    $graph_builder->set_plot_values($graphics_data);
    return $graph_builder->get_png();
  }

  public function set_width($width)
  {
    $this->width=$width;
  }

  public function set_height($height)
  {
    $this->height=$height;
  }
}
?>
