<?
class ttt_calculator
{
  const MBTI_E = "E";
  const MBTI_I = "I";
  const MBTI_S = "S";
  const MBTI_N = "N";
  const MBTI_T = "T";
  const MBTI_F = "F";
  const MBTI_J = "J";
  const MBTI_P = "P";

  const MBTI_E_I = 1;
  const MBTI_S_N = 2;
  const MBTI_T_F = 3;
  const MBTI_J_P = 4;

  const KT_GUARDIAN = 1;
  const KT_ARTISAN = 2;
  const KT_RATIONAL = 3;
  const KT_IDEALIST = 4;

  private $db;

  private static $mbti_types = array(self::MBTI_E => self::MBTI_E_I, 
                              self::MBTI_I => self::MBTI_E_I,
                              self::MBTI_S => self::MBTI_S_N,
                              self::MBTI_N => self::MBTI_S_N,
                              self::MBTI_T => self::MBTI_T_F, 
                              self::MBTI_F => self::MBTI_T_F,
                              self::MBTI_J => self::MBTI_J_P, 
                              self::MBTI_P => self::MBTI_J_P
                              );

  private $mbti_dimensions = array(self::MBTI_E_I => array(self::MBTI_E, self::MBTI_I),
                                   self::MBTI_S_N => array(self::MBTI_S, self::MBTI_N),
                                   self::MBTI_T_F => array(self::MBTI_T, self::MBTI_F),
                                   self::MBTI_J_P => array(self::MBTI_J, self::MBTI_P)
                                  );

  private $preferred_mbti_types = array(self::MBTI_E_I => self::MBTI_I,
                                        self::MBTI_S_N => self::MBTI_S,
                                        self::MBTI_T_F => self::MBTI_T,
                                        self::MBTI_J_P => self::MBTI_J
                                        );

  private $neglected_mbti_types = array(self::MBTI_E_I => self::MBTI_E,
                                        self::MBTI_S_N => self::MBTI_N,
                                        self::MBTI_T_F => self::MBTI_F,
                                        self::MBTI_J_P => self::MBTI_P
                                       );

  private $kersey_temperaments = array(self::KT_GUARDIAN => array(self::MBTI_S, self::MBTI_J),
                                       self::KT_ARTISAN => array(self::MBTI_S, self::MBTI_P),
                                       self::KT_RATIONAL => array(self::MBTI_N, self::MBTI_T),
                                       self::KT_IDEALIST => array(self::MBTI_N, self::MBTI_F)
                                       );

  private $mbti_type_values = array();

  private $mbti_dimension_values = array();

  /**
   * constructor
   *
   * @param object $db
   */
  public function __construct($db)
  {
    $this->db = $db;
    $this->_reset_mbti_type_values();
  }

  /**
   * destructor
   *
   */
  public function __destruct()
  {
  }

  /**
   * save results
   *
   * @param int $uid 
   * @param array $mbti_types - assoc array with MBTI-types and their posted values
   */
  public function save_ttt($uid, $mbti_types)
  {
    $this->_count_mbti_types($mbti_types);
    $this->_calculate_mbti_dimensions($this->mbti_type_values);
    $personality_type = $this->_get_personality_type();
    $kersey_temperament = $this->_get_kersey_temperament();

    $data["uid"] = $uid;
    $data["dt_ttt"] = "NOW()";

    foreach($this->mbti_type_values as $mbti_type => $value)
      {
        if(in_array($mbti_type, $personality_type))
          $data[$mbti_type] = 1;
        else
          $data[$mbti_type] = 0;

        $data[$mbti_type."_val"] = $value;
      }

    $data["kersey_temperament"] = $kersey_temperament;

    return user_model::save_user_data($data, $uid);
  }

  /**
   * delivers ttt-questions data from db
   *
   * @param int $uid
   */
  public function get_mbti_dimension($mbti_type)
  {
    return self::$mbti_types[$mbti_type];
  }

  /**
   * resets the internal MBTI-type values
   *
   */
  private function _reset_mbti_type_values()
  {
    $this->mbti_type_values = array(self::MBTI_E => 0, 
                                    self::MBTI_I => 0,
                                    self::MBTI_S => 0, 
                                    self::MBTI_N => 0,
                                    self::MBTI_T => 0, 
                                    self::MBTI_F => 0,
                                    self::MBTI_J => 0, 
                                    self::MBTI_P => 0
                                    );
  }

  /**
   * counts the nswers per MBTI-type
   *
   * @param array $post_mbti_types - assoc array with MBTI-types and their posted values
   */
  private function _count_mbti_types($post_mbti_types)
  {
    $this->_reset_mbti_type_values();
    foreach($this->mbti_type_values as $mbti_type => $value)
      $this->mbti_type_values[$mbti_type] = $post_mbti_types[$mbti_type]?$post_mbti_types[$mbti_type]:0;
  }

  /**
   * calculates the values per dimension
   *
   */
  private function _calculate_mbti_dimensions($mbti_type_values)
  {
    $this->mbti_dimension_values = array();

    foreach($this->mbti_dimensions as $mbti_dimension => $mbti_types)
      {
        $type_a = $mbti_types[0];
        $type_b = $mbti_types[1];

        if($mbti_type_values[$type_a] == $mbti_type_values[$type_b])
          {
            $stronger_mbti_type = $this->preferred_mbti_types[$mbti_dimension];
            $weaker_mbti_type = $this->neglected_mbti_types[$mbti_dimension];
          }
        else if($mbti_type_values[$type_a] < $mbti_type_values[$type_b])
          {
            $stronger_mbti_type = $type_b;
            $weaker_mbti_type = $type_a;
          }
        else
          {
            $stronger_mbti_type = $type_a;
            $weaker_mbti_type = $type_b;
          }

        $this->mbti_dimension_values[$stronger_mbti_type] = $mbti_type_values[$stronger_mbti_type] - $mbti_type_values[$weaker_mbti_type];
      }
  }


  /**
   * delivers the kersey temperament
   *
   * @return int $kersey_temperament
   */
  private function _get_kersey_temperament()
  {
    $personality_type = $this->_get_personality_type();

    foreach($this->kersey_temperaments as $kersey_temperament => $mbti_types)
      {
        if(in_array($mbti_types[0], $personality_type) && in_array($mbti_types[1], $personality_type))
          return $kersey_temperament;
      }

    return 0;
  }


  /**
   * delivers the personality type
   *
   * @return array 
   */
  private function _get_personality_type()
  {
    return array_keys($this->mbti_dimension_values);
  }

  public function get_mbti_dimensions()
  {
    return $this->mbti_dimensions;
  }

  public static function get_mbti_text($mbti_value)
  {
    switch($mbti_value)
    {
      case self::MBTI_E_I:
        return "E-I";
      case self::MBTI_S_N:
        return "S-N";
      case self::MBTI_T_F:
        return "T-F";
      case self::MBTI_J_P:
        return "J-P";
      default:
        return "";
    }
  }

  public static function get_mbti_types()
  {
    return array_keys(self::$mbti_types);
  }

  public static function get_mbti_types_dimensions()
  {
    return self::$mbti_types;
  }

  public function get_mbti_test_results($mbti_type_values)
  {
    $this->_calculate_mbti_dimensions($mbti_type_values);
    return $this->mbti_dimension_values;
  }

  public static function get_keirsey_temperament_text($keirsey_temperament)
  {
    switch($keirsey_temperament)
    {
    case self::KT_GUARDIAN:
      return "Guardian";
    case self::KT_ARTISAN:
      return "Artisan";
    case self::KT_RATIONAL:
      return "Rational";
    case self::KT_IDEALIST:
      return "Idealist";
      default:
        return "";
    }
  }
}
?>
