<?php

require_once 'D100/Controller/Web.php';
require_once 'Platforms/Form/Login.php';
require_once 'Platforms/Form/Register.php';
require_once 'models/UserModel.php';
require_once('Auth.php');

class IndexController extends Platforms_Controller_Web {

  protected $_route_noRoute = array('success' => 'forward:login');
  protected $_route_index = array('success' => 'forward:login');
  protected $_route_tttform = array('form' => 'view:/tttform', 'result'=>'view:/tttresult');
  protected $_route_login = array('showForm' => 'view:login',
                                  'success' => 'redirect:/profile/status');
  protected $_route_register = array('showForm' => 'view:register',
                                     'success' => 'redirect:/profile/status');

  public function __construct() {
    parent::__construct();
    if(Auth::getInstance()->isUserLogged()) {
      self::$_view->is_logged = true;
      self::$_view->user_id = Auth::getInstance()->getLoggedUser()->getId();
    }

    self::$_view->pageTitle = 'Home';
  }

  public function noRouteAction() {
    return 'success';
  }

  public function indexAction() {
    return 'success';
  }

  public function logoutAction() {
    $auth = Auth::getInstance();
    $auth->invalidateSession();
    $this->_redirect('/');
  }

  /**
   * Login-Action used for authenticating the user.
   *
   * @param Form_Login $form
   * @return string
   */
  public function loginAction(Form_Login $form) {
    $container = $form->getContainer();
    $v = $this->getView();
    $form->setView($v);
    $form->assignFields();

    // check the form for valid input...
    if($_SERVER['REQUEST_METHOD'] != 'POST') {
      return 'showForm';
    }
    if($container->isEmpty() || !$container->isValid()) {
      $v->loginFailed = true;
      return 'showForm';
    }
    
    if(!UserModel::authenticate($container->user_name, $container->password)) {
      $v->loginFailed = true;
      return 'showForm';
    }
    return 'success';
  }

  /**
   * Registration-Action used for initially registering the user.
   *
   * @param Form_Register $form
   * @return string
   */
  public function registerAction(Form_Register $form) {
    $container = $form->getContainer();
    $v = $this->getView();
    $form->setView($v);
    $form->assignFields();

    // check the form for valid input...
    if($_SERVER['REQUEST_METHOD'] != 'POST') {
      return 'showForm';
    }
    if(!$container->isValid()) {
      $v->assignPrefixed('error_', $container->getFieldExceptionList());
      $v->registrationFailed = true;
      return 'showForm';
    }
    
    
    $userMod = UserModel::create($container);
    if($userMod===-1) {
      $v->userAlreadyExists = true;
      $v->registrationFailed = true;
      return 'showForm';
    }
    if($userMod===-2) {
      $v->invalidGeoCode = true;
      $v->registrationFailed = true;
      return 'showForm';
    }
    
    // now log the user in:
    
    $myId = $userMod->getId();
    
    $userMod = UserModel::getInstance($myId);
    $userMod->last_login = time();
    $userMod->save();

    $_SESSION['user_id'] = $userMod->getId();
    $_SESSION['last_login'] = $userMod->last_login;

    return 'success';
  }

  public function tttformAction($submitted, $answer) {
    if($submitted!=1) return 'form';
    else {
      require_once('ttt.php');
      // let us first check if the user has answered all questions:
      if(!is_array($answer)) return 'form';
      //if(count($answer<40)) return 'form';
      // now gather all the information from the radiobuttons
      // and calculate the type.
      $ttt = new TTT();
      foreach($answer AS $key=>$aspect) {
        $fct = 'add'.$aspect;
        $ttt->$fct();
      }
      $v = $this->getView();
      $v->TTType = $ttt->getTTType();
      $v->MBTIType = $ttt->getMBTIType();
      $v->MBTITypeNumeric = $ttt->getMBTITypeNumeric();
      $v->keirseyType = $ttt->getKeirseyType();
      return 'result';
    }
  }
}
?>