<?php

require_once 'D100/Controller/Web.php';
require_once 'Platforms/Form/Login.php';

class ProfileController extends Platforms_Controller_Web {
  protected $_route_index = array('success' => 'forward:status');
  protected $_route_status = array('success' => 'view:status');
  protected $_route_statusOthers = array('success' => 'view:status_others');
  protected $_route_view = array('success' => 'view:view');
  protected $_route_tttform = array('form' => 'view:/tttform', 'result'=>'view:/tttresult');
  protected $_route_rcdAccept = array('success' => 'redirect:/profile/status');
  protected $_route_rcdReject = array('success' => 'redirect:/profile/status');
  protected $_continue_rcdSendRequest = 'redirect:/profile/statusOthers';

  public function __construct() {
    $this->getCurrentUser();
    parent::__construct();
    self::$_view->pageTitle = 'Profile';
  }

  public function noRouteAction() {
    return 'success';
  }

  public function indexAction() {
    return 'success';
  }

  public function viewAction() {
    return 'success';
  }

  public function rcdAcceptAction($userId) {
    $this->_currentUser->acceptUser($userId);
    self::$_view->accepptMsg = true;

    return 'success';
  }

  public function rcdRejectAction($userId) {
    $this->_currentUser->rejectUser($userId);
    self::$_view->rejectMsg = true;

    return 'success';
  }

  public function rcdSendRequestAction($userId) {
    $this->_currentUser->sendRequestTo($userId);
    self::$_view->accepptMsg = true;

    $this->_continue('rcdSendRequest', array('userId' => $userId));
  }


  public function statusOthersAction($userId=null) {
    return $this->statusAction($userId);
  }

  public function statusAction($userId=null) {
    $loggedUserId = $this->_currentUser->getId();
    if(!$userId) $userId = $loggedUserId;

    self::$_view->viewer_is_in_contact = $this->_currentUser->isInContact($userId);

    // check if a user exists with the given id
    $userMod = UserModel::getInstance($userId);
    $user2showId = $userMod->getId();

    if($loggedUserId == $user2showId) self::$_view->viewer_is_logged_user = true;
    else self::$_view->viewer_is_logged_user = false;

    // overide the userId of the currently logged in user with the
    // one to show
    self::$_view->user_id = $userId;

    return 'success';
  }

  public function tttformAction($submitted, $answer) {
    $v = $this->getView();
    if($submitted!=1) return 'form';
    else {
      require_once('ttt.php');
      // let us first check if the user has answered all questions:
      if(!is_array($answer)) return 'form';

      $count = array_count_values($answer);

      if(!isset($count['E'])) $count['E'] = 0;
      if(!isset($count['I'])) $count['I'] = 0;
      if(!isset($count['S'])) $count['S'] = 0;
      if(!isset($count['J'])) $count['J'] = 0;
      if(!isset($count['T'])) $count['T'] = 0;
      if(!isset($count['N'])) $count['N'] = 0;
      if(!isset($count['P'])) $count['P'] = 0;
      if(!isset($count['F'])) $count['F'] = 0;

      if(($count['E'] + $count['I']) < 5
      || ($count['S'] + $count['N']) < 5
      || ($count['J'] + $count['P']) < 5
      || ($count['T'] + $count['F']) < 5) {
        $GLOBALS['answer'] = $answer;
        $v->not_complete = true;
        return 'form';
      }

      // now gather all the information from the radiobuttons
      // and calculate the type.
      $ttt = new TTT();
      foreach($answer AS $key=>$aspect) {
        $fct = 'add'.$aspect;
        $ttt->$fct();
      }

      $v->TTType = $ttt->getTTType();
      $v->MBTIType = $ttt->getMBTIType();
      $v->MBTITypeNumeric = $ttt->getMBTITypeNumeric();
      $v->keirseyType = $ttt->getKeirseyType();

      $user = $this->getCurrentUser();

      $data = $ttt->getRawData();

      $user->EI = $data['EI'];
      $user->SN = $data['SN'];
      $user->TF = $data['TF'];
      $user->JP = $data['JP'];

      $user->ttt_type = $ttt->getMBTIType();
      $user->mbti_type = $ttt->getMBTITypeNumeric();
      $user->mbti_timestamp = time();
      $user->save();

      return 'result';
    }
  }
}
?>
