<?php

require_once 'D100/Controller/Web.php';
require_once 'Platforms/Form/Login.php';
require_once 'models/UsersModel.php';
require_once 'Platforms/Form/Search.php';
require_once 'ttt.php';

class SearchController extends Platforms_Controller_Web {
  protected $_route_index = array('success' => 'forward:users');
  protected $_route_users = array('form' => 'view:search', 'results' => 'view:results');
  protected $_route_graph = array('form' => 'view:graph');
  protected $x_options = array ('EI','SN','JP','TF');
  protected $y_options = array ('EI','SN','JP','TF');

  public function __construct() {
    $this->getCurrentUser();
    parent::__construct();
    self::$_view->pageTitle = 'Search';
  }

  public function indexAction() {
    return 'success';
  }

  public function graphimageAction () {
    require_once('searchGraph.php');


    if(isset($_SESSION['x'])) {
      $x = $_SESSION['x'];
    } else {
      $x = 0;
    }

    if(isset($_SESSION['y'])) {
      $y = $_SESSION['y'];
    } else {
      $y = 1;
    }

    $search = $_SESSION['search'];

    $search['only_tested'] = 1;

    $currentUser = $this->getCurrentUser();

    $users = UsersModel::searchUsers($search, $currentUser->getId());

    $toArr = array();
    $fromArr = array();
    $noArr = array();

    $key_x = strtolower($this->x_options[$x]);
    $key_y = strtolower($this->y_options[$y]);

    foreach($users as $user) {
      if($user['contact_status'] == 'TO') {
        $toArr[] = array('x' => $user[$key_x], 'y' => $user[$key_y]);
      }
      elseif($user['contact_status'] == 'FROM') {
        $fromArr[] = array('x' => $user[$key_x], 'y' => $user[$key_y]);
      }
      else {
        $noArr[] = array('x' => $user[$key_x], 'y' => $user[$key_y]);
      }
    }

    $g = new SearchGraph();

    if(is_numeric($currentUser->getValue($key_x)) && is_numeric($currentUser->getValue($key_y))) {
      $g->plotMySelf($currentUser->getValue($key_x),$currentUser->getValue($key_y));
    }

    if(!empty($noArr)) {
      $g->plotNoContact($noArr);
    }
    if(!empty($fromArr)) {
      $g->plotRCDSent($fromArr);
    }
    if(!empty($toArr)) {
      $g->plotRCDReceived($toArr);
    }

    $g->setTitle('Result graph - Distribution of members');
    $g->setXAxisTitle($this->x_options[$x]);
    $g->setYAxisTitle($this->y_options[$y]);
    $g->output();

}

  public function graphAction ($x, $y, $z) {
    $v = $this->getView();

    if($x == null && isset($_SESSION['x'])) {
      $x = $_SESSION['x'];
    } else {
      $_SESSION['x'] = $x;
    }

    if($y == null && isset($_SESSION['y'])) {
      $y = $_SESSION['y'];
    } else {
      $_SESSION['y'] = $y;
    }

    if($x == null) {
      $x = 0;
    }

    if($y == null) {
      $y = 1;
    }

    $v->x_select = $v->formSelect('x', $x, array('id' => 'xSelect'), $this->x_options);
    $v->y_select = $v->formSelect('y', $y, array('id' => 'ySelect'), $this->y_options);

    return 'form';
  }

  public function usersAction($search, $show_results) {
    $v = $this->getView();
    $user = $this->getCurrentUser();


    if($search == null && isset($_SESSION['search'])) {
      $search = $_SESSION['search'];
    } else {
      $_SESSION['search'] = $search;
    }

    if(isset($search['not_contact'])) {
      $v->input_not_contact = $v->formCheckbox('search[not_contact]', $search['not_contact'], array('id' => 'not_contact'));
    } else {
      $v->input_not_contact = $v->formCheckbox('search[not_contact]', 0, array('id' => 'not_contact'));
    }

    if(isset($search['motto'])) {
      $v->input_motto = $v->formText('search[motto]', $search['motto'], array('id' => 'motto'));
    } else {
      $v->input_motto = $v->formText('search[motto]', '', array('id' => 'motto'));
    }

    if(isset($search['distance'])) {
      $v->input_distance = $v->formText('search[distance]', $search['distance'], array('id' => 'distance'));
      $search['lat'] = $user->getValue('geo_lat');
      $search['long'] = $user->getValue('geo_long');
    } else {
      $v->input_distance = $v->formText('search[distance]', '', array('id' => 'distance'));
    }

    $ttt = '';

    $types = array_flip(TTT::$mbtiType);

    // $types = array('3' => 'Unknown');

    foreach($types as $typeId => $type) {
      $htmlId = 'ttt_'.$typeId;

      if(isset($search['ttt'][$typeId])) {
        $ttt .= $v->formCheckbox('search[ttt]['.$typeId.']', $search['ttt'][$typeId], array('id' => $htmlId ));
      } else {
        $ttt .= $v->formCheckbox('search[ttt]['.$typeId.']', 0, array('id' => $htmlId));
      }

      $ttt .= ' <label for="'.$htmlId .'">'.$type.'</label><br />';
    }

    $v->input_ttt = $ttt;

    if($show_results && $search != null) {
      $startTime = get_microtime();

      $results = UsersModel::searchUsers($search, $this->getCurrentUser()->getId());

      if($results === false) {
        $v->not_complete = true;
        return 'form';
      }

      if(count($results) == 0) {
        $v->no_results = true;
        return 'form';
      }

      $v->users = $v->escape($results);

      $v->resultCount = count($v->users);

      $v->queryTime = round(get_microtime() - $startTime, 4);

      return 'results';
    }

    return 'form';
  }
}
?>