<?php

require_once 'D100/Controller/Web.php';
require_once 'Platforms/Form/Login.php';
require_once 'Platforms/Form/Register.php';
require_once 'models/UserModel.php';

class IndexController extends Platforms_Controller_Web {

  protected $_route_noRoute = array('success' => 'view:index');
  protected $_route_index = array('success' => 'view:index');
  protected $_route_tttform = array('form' => 'view:/tttform', 'result'=>'view:/tttresult');
  protected $_route_login = array('showForm' => 'view:login',
                                  'success' => 'redirect:/profile/status');
  protected $_route_register = array('showForm' => 'view:register',
                                     'success' => 'redirect:/profile/status');

  public function __construct() {
    parent::__construct();
    if(Auth::getInstance()->isUserLogged()) {
      self::$_view->is_logged = true;
      self::$_view->user_id = Auth::getInstance()->getLoggedUser()->getId();
    }

    self::$_view->pageTitle = 'Home';
  }

  public function noRouteAction() {
    return 'success';
  }

  public function indexAction() {
    return 'success';
  }

  public function logoutAction() {
    $_SESSION = array();
    session_unset();
    setcookie (session_name(), '', (time () - 2592000), '/', '', 0);
    session_destroy();

    $this->_redirect('/');
  }

  /**
   * Login-Action used for authenticating the user.
   *
   * @param Form_Login $form
   * @return string
   */
  public function loginAction(Form_Login $form) {
    $container = $form->getContainer();
    $v = $this->getView();
    $form->setView($v);
    $form->assignFields();

    // check the form for valid input...
    if($_SERVER['REQUEST_METHOD'] != 'POST') {
      return 'showForm';
    }
    if($container->isEmpty() || !$container->isValid()) {
      $v->loginFailed = true;
      return 'showForm';
    }

    // check if the user is registered via looking up in db
    $userMod = UserModel::getInstanceByUsername($container->user_name);
    if($userMod == null) {
      $v->loginFailed = true;
      return 'showForm';
    }

    // now check if the password matches...
    if($userMod->password != $container->password) {
      $v->loginFailed = true;
      return 'showForm';
    }

    $_SESSION['user_id'] = $userMod->getId();
    $_SESSION['last_login'] = $userMod->last_login;

    $userMod->last_login = time();
    $userMod->save();

    return 'success';
  }

  /**
   * Registration-Action used for initially registering the user.
   *
   * @param Form_Register $form
   * @return string
   */
  public function registerAction(Form_Register $form) {
    $container = $form->getContainer();
    $v = $this->getView();
    $form->setView($v);
    $form->assignFields();

    // check the form for valid input...
    if($_SERVER['REQUEST_METHOD'] != 'POST') {
      return 'showForm';
    }
    if($container->isEmpty() || !$container->isValid()) {
      $v->assignPrefixed('error_', $container->getFieldExceptionList());
      $v->registrationFailed = true;
      return 'showForm';
    }

    // check if the user's username is already registered via looking up in db
    $userMod = UserModel::getInstanceByUsername($container->user_name);
    if($userMod != null) {
      $v->userAlreadyExists = true;
      $v->registrationFailed = true;
      return 'showForm';
    }

    // create new user and store it in db

    $userMod = UserModel::getInstance();

    $userMod->password = $container->password;
    $userMod->user_name = $container->user_name;
    $userMod->full_name = $container->full_name;
    $userMod->email = $container->email;
    $userMod->town = $container->town;
    $userMod->country = $container->country;
    $userMod->life_motto = $container->life_motto;
    $userMod->secondary_life_motto = $container->secondary_life_motto;

    $userMod->last_login = time();

    $userMod->save();

    $_SESSION['user_id'] = $userMod->getId();
    $_SESSION['last_login'] = $userMod->last_login;

    return 'success';
  }

  public function tttformAction($submitted, $answer) {
    if($submitted!=1) return 'form';
    <?php
include ("jpgraph/jpgraph.php");
include ("jpgraph/jpgraph_scatter.php");

class SearchGraph {
  /**
   * JPGraph Graph Object
   *
   * @var Graph
   */
  protected $graph;
    
  function __construct($width=600, $height=400) {
    $this->graph = new Graph(600,400,"auto");
    $this->graph->SetScale("linlin",-20,20,-10,10);
    $this->graph->img->SetMargin(40,120,40,40);	// left,right,top,bottom	
    $this->graph->SetShadow();
  }
  
  function setTitle($head) {
    $this->graph->title->Set($head);
    $this->graph->title->SetFont(FF_FONT1,FS_BOLD);
  }
  
  function setXAxisTitle($title) {
    $this->graph->xaxis->SetTitle($title,'middle'); 
    $this->graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);
    $this->graph->xaxis->SetTitlemargin(155);    
  }
  
  function setYAxisTitle($title) {
    $this->graph->yaxis->SetTitle('S/J','middle'); 
    $this->graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD);
    $this->graph->yaxis->SetTitlemargin(230);
  }
  
  protected function randomize($origValue, $randomizer=0.33) {
    $res = $origValue;
    $rnd = rand(1,10);
    if($rnd<3) $res -= $randomizer;
    elseif($rnd>7) $res += $randomizer;
    return $res;
  }
  
  protected function doPlot($arr, $type, $color, $width, $legend) {
    $x = array();
    $y = array();
    foreach($arr AS $uid=>$coords) {
      // build arrays in the form that jpgraph needs and
      // also randomized add/substract 0.33 from x or y
      $x[] = $this->randomize($coords['x']);
      $y[] = $this->randomize($coords['y']);
    }
    $sp1 = new ScatterPlot($y,$x);
    $sp1->mark->SetType($type);
    $sp1->mark->SetFillColor($color);
    $sp1->mark->SetWidth($width);
    $sp1->SetLegend($legend);
    $this->graph->Add($sp1);
  }
  
  function plotMySelf($x,$y) {
    $arr = array(array('x'=>$x,'y'=>$y));
    $this->doPlot($arr, MARK_FILLEDCIRCLE, "blue", 8, "You");
  }
  
  function plotNoContact($arr) {
    $this->doPlot($arr, MARK_X, "black", 5, "No Contact");
  }
  
  function plotRCDSent($arr) {
    $this->doPlot($arr, MARK_FILLEDCIRCLE, "red", 4, "RCD sent");
  }
  
  function plotInContact($arr) {
    $this->doPlot($arr, MARK_FILLEDCIRCLE, "green", 4, "In Contact");
  }
  
  function plotRCDReceived($arr) {
    $this->doPlot($arr, MARK_FILLEDCIRCLE, "violet", 4, "RCD received");
  }
  
  function output() {
    $this->graph->legend->Pos(0.02,0.5,"right","center");
    $this->graph->Stroke();
  }
}
?>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         <?php

require_once('D100/Template/SectionIterator.php');
require_once('models/DeploymentModel.php');

class ArchiveListSection extends D100_Template_SectionIterator {
  
  private $archiveList = array();
  
  public function init(D100_Template_ValueObject $valueObject) {
    $mod = new DeploymentModel();
    $properties = $mod->getProjectProperties($valueObject->projectId);
    
    $buildDir = $properties['build.dir'];
    $archiveList = array();
    // it may be that the buildDir has not yet been crated, so check....
    if(is_dir($buildDir)) {
      $dir = new DirectoryIterator($buildDir);
      foreach($dir as $file) {
        if($file->isDot()) continue;
        $name = 
        $archiveList[] =
          array('name' => $file->getFilename(),
                'modified' => date('d/m/Y H:i.s', $file->getMTime()),
                'size_kb' => ($file->getSize() + 1023) >> 10);
      }
    }
    
    self::array_key_multi_sort($archiveList, 'name', 'desc');
    
    $this->archiveList = $archiveList;
  }

  /**
   * this function is based on:
   * http://de2.php.net/manual/en/function.array-multisort.php#54867
   * 
   * orders a multidimentional array on the base of a label-key
   *
   * @param $arr, the array to be ordered
   * @param $l the "label" identifing the field
   * @param $o specifying the sort order: asc or desc
   * @param $f the ordering