<?php

/**
 * Rightsconfiguration for users.
 */
class Auth {
  private static $instance;
  /**
   * list of controllernames which need NO authentication.
   * 
   * @var array
   */
  private static $needsNoAuth = array('index','soap');
  private static $noSession = array('soap');
    
  /**
   * Prevent direct instantiation, use getInstance() instead.
   */
  protected function __construct() { }
  
  /**
   * @return Auth
   */
  public function getInstance() {
    if(self::$instance === null) self::$instance = new self;
    return self::$instance;
  }
  
  public function isAllowed($controller) {
    if($controller) $controller = strtolower($controller);
    if(!in_array($controller,self::$noSession)) {
      if(session_id()=='') session_start();
    }
    if(in_array($controller, self::$needsNoAuth)) return true;
    if($this->isUserLogged()) return true;
    
    return false;
  }
  
  public function isUserLogged() {
    if(isset($_SESSION['user_id'])) return true;
    else return false;
  }
  
  /**
   * Returns the userModel regarding to the currently logged in user.
   *
   * @return UserModel
   */
  public function getLoggedUser() {
    if($this->isUserLogged()) return UserModel::getInstance($_SESSION['user_id']);
    else return null;
  }
  
  public function getUid() {
    return $_SESSION['user_id'];
  }
  
  public function invalidateSession() {
    $_SESSION = array();
    session_unset();
    setcookie (session_name(), '', (time () - 2592000), '/', '', 0);
    session_destroy();
  }
}
?>