<?php

require_once 'Zend/Controller/Plugin/Abstract.php';
require_once 'Auth.php';

class AuthControllerPlugin extends Zend_Controller_Plugin_Abstract {
	
  private $auth;
  
  public function __construct() {
	  $this->auth = Auth::getInstance();
	}
	
  public function preDispatch($action) {
	  $allowed = $this->auth->isAllowed($action->getControllerName());
	  if(!$allowed) {
	    // redirect to access denied page
      $action->setControllerName('index');
      $action->setActionName('login');
	  };
	  
	  return $action;
  }
}
?>