<?php
define('GEO_REGEX','(\d+(\.\d+)?) ?([NnSs]) ?,? ?(\d+(.\d+)?) ?([EeWw])');

class GEOCode {
  static function convertStr2GEOCode($code) {
    $arr = array();
    preg_match('/'.GEO_REGEX.'/', $code, $arr);
    if(!$arr) throw new Exception('invalid GEOCode!');

    if(strtolower($arr[3])=='s') $lat = 0-$arr[1];
    else $lat = (float)$arr[1];
    if(strtolower($arr[6])=='w') $long = 0-$arr[4];
    else $long = (float)$arr[4];

    return array($lat, $long);
  }

  static function convertGEOCode2Str($lat, $long) {
    if($lat==null && $long==null) return NULL;
    if($lat<0) $latStr = abs($lat).' S';
    else $latStr = $lat.' N';

    if($long<0) $longStr = abs($long).' W';
    else $longStr = $long.' E';
    return $latStr.', '.$longStr;
  }

  static function generateSelectClause($lat,$long) {
    return "(((acos(sin(($lat*pi()/180)) * sin((geo_lat*pi()/180)) + cos(($lat*pi()/180)) * cos((geo_lat*pi()/180)) * cos((($long - geo_long)*pi()/180))))*180/pi())*60*1.8424) as distance";
  }
}