<?php

/**
 * @author 	   Michael Mayer <michael.mayer@zend.com>
 */

require_once('models/UserModel.php');
require_once('D100/Controller/Web.php');

abstract class Platforms_Controller_Web extends D100_Controller_Web {

  protected $_route_index     = array('success' => 'view:index');
  /**
	 * The current locale string
	 *
	 * @var string
	 */
  protected $_locale    = DEFAULT_LOCALE;
  /**
	 * The current db object
	 *
	 * @var Zend_Db_Adapter_Abstract
	 */
  protected $_db               = null;
  /**
	 * The current log object
	 *
	 * @var LogModel
	 */
  protected $_log              = null;
  /**
	 * The current user
	 *
	 * @var UserModel
	 */
  protected $_currentUser      = null;
  /**
	 * Session data
	 *
	 * @var array
	 */
  protected $_session          = null;
  /**
	 * The current users session initial (may be different from the user's real initial,
	 * as the aliases table is not used for sessions!)
	 *
	 * @var string
	 */
  protected $_sessionInitial   = null;

  /**
	 * Initialize the controller (set locale, load user and check for permissions)
	 *
	 */
  public function __construct() {
    parent::__construct();
    self::$_view->setEscape(array(get_class($this), 'sanitize'));

    self::$_view->siteTitle = 'Plat_forms - People by Temperament';
    self::$_view->pageTitle = 'Unknown';

    $this->setLocale(DEFAULT_LOCALE);

    // BIG TODO: Session starten und UserModel laden!!!!!

    /*
    if(!$this->loadSessionValues(CMSUser::getInitial())) {
      throw new Exception('Could not load user session for '.CMSUser::getInitial());
    }

    if($this->getSessionValue('locale') == null) {
      $this->setLocale(DEFAULT_LOCALE);
    } else {
      $this->setLocale($this->getSessionValue('locale'));
    }

    */

    if($this->_currentUser != null) {
      self::$_view->currentUserId = $this->_currentUser->getId();
      self::$_view->full_name = $this->_currentUser->full_name;
      self::$_view->is_logged = true;
      self::$_view->user_id = $this->_currentUser->getId();
    }
  }

  /**
	 * Load the user's session
	 *
	 * @param string $initial
	 * @return boolean
	 */
  public function loadSessionValues ($initial) {
    if(!is_string($initial)	|| $initial == '') {
      return false;
    }

    $db = $this->getDb();

    $this->_sessionInitial = $initial;

    $select = $db->select();
    $select->from('mdb_userSessions', 'session');
    $select->where('initial = ?', $initial);
    $results = $db->fetchOne($select);

    if(is_array($results) && isset($results[0])) {
      $this->_session = unserialize($results[0]);
    } else {
      $db->insert('mdb_userSessions', array('initial' => $initial, 'session' => serialize(array())));
      $this->_session = array();
    }

    return true;
  }

  /**
	 * Get a user's session value for the given session variable name
	 *
	 * @param string $name
	 * @return mixed
	 */
  public function getSessionValue ($name) {

    if(!is_array($this->_session)) {
      throw new Exception('Session not loaded in CMS_Controller_Web::getSessionValue()');
    }

    if(isset($this->_session[$name])) {
      $result = $this->_session[$name];
    } else {
      $result = null;
    }

    return $result;
  }

  /**
	 * Set a key-value pair for this user's session
	 *
	 * @param string $name
	 * @param mixed $value
	 */
  public function setSessionValue ($name, $value) {
    if(!is_array($this->_session) || $this->_sessionInitial == '') {
      throw new Exception('Session not loaded in CMS_Controller_Web::setSessionValue()');
    }

    $db = $this->getDb();

    $this->_session[$name] = $value;

    $where = $db->quoteInto('initial = ?', $this->_sessionInitial);

    $db->update('mdb_userSessions', array('session' => serialize($this->_session)), $where);
  }

  /**
   * neben dem Parentaufruf wird die Sprache gesetzt, wenn die Variable
   * locale als Parameter �bergeben wurde. SPrache wird in der Session
   * gespeichert und als Instanzvariable in CMS_Controller_Web gesetzt.
   *
   * @param Zend_Controller_Dispatcher_Token $token
   */
  function setAction(Zend_Controller_Dispatcher_Token $token) {
    $myParams = $token->getParams();
    $v = $this->getView();

    parent::setAction($token);

    $v->controller = $token->getControllerName();
    $v->action = $token->getActionName();

    $urlParams = '';

    foreach($token->getParams() as $paramKey => $paramValue) {
      $urlParams .= '/'.urlencode((string) $paramKey).'/'.urlencode((string) $paramValue);
    }

    $v->params = $urlParams;

    $v->currentLocale = $this->getLocale();
  }

  /**
	 * Liefert View-Object des Web-Controllers
	 *
	 * @return Zend_View
	 */
  public function getView() {
    $v = self::$_view;
    return $v;
  }

  /**
   * Returns a refernce to the current Zend_Db_Adapter_Abstract object
   *
   * @return Zend_Db_Adapter_Abstract
   */
  private final static function getDbObject () {
    if(Zend::isRegistered('default_db')) {
      return Zend::registry('default_db');
    }
    elseif(Zend::isRegistered('db')) {
      return Zend::registry('db');
    }

    throw new Exception('Database not found in Zend::registry');
  }

  /**
   * Returns a reference to the current log object
   *
   * @return LogModel
   */
  public function getLog () {
    if($this->_log === null) {
      $this->_log = LogModel::getInstance();
    }
    return $this->_log;
  }

   /**
   * Returns the current user (identified by initial)
   *
   * @return UserModel
   */
  public function getCurrentUser () {
    if($this->_currentUser != null) return $this->_currentUser;

    $userMod = Auth::getInstance()->getLoggedUser();
    if($userMod == null) throw new Exception('Fatal. impossible to instantiate user. no user logged in!');
    $this->_currentUser = $userMod;

    return $userMod;
  }


  /**
   * Returns a reference to the current db object
   *
   * @return Zend_Db_Adapter_Abstract
   */
  public function getDb () {
    if($this->_db === null) {
      $this->_db = self::getDbObject();
    }
    return $this->_db;
  }

  /**
	 * Returns current locale string
	 *
	 * @return string
	 */
  public function getLocale () {
    $locale = $this->_locale;

    return $locale;
  }

  /**
   * Sets a new current locale
   *
   * @param string $locale
   * @return string
   */
  public function setLocale ($locale) {
    if(strlen($locale) > 2 && strpos($locale, '_') === false) {
      throw new Exception('The locale fomat is not correct: '.$locale);
    }

    $this->_locale = $locale;

    return $this->_locale;
  }

  /**
	 * Escapes a string and adds <br /> tags for new lines
	 *
	 * @param unknown_type $input
	 * @return unknown
	 */
  public static function sanitizeString ($input) {
    $result = trim($input);
    $result = htmlspecialchars($result, ENT_QUOTES);
    $result = nl2br($result);

    return $result;
  }

  /**
	 * Sanitize method which accepts many different types as parameters (strings, numbers, arrays,
	 * multi-dimensional arrays)
	 *
	 * @param mixed $content
	 * @return mixed
	 */
  public static function sanitize ($content) {
    if(is_string($content)) {
      $result = self::sanitizeString($content);
    }
    elseif(is_numeric($content)) {
      $result = $content;
    }
    elseif(is_null($content)) {
      $result = null;
    }
    elseif(is_object($content)) {
      $result = self::sanitizeString((string) $content);
    }
    elseif(is_array($content)) {
      $result = array();

      foreach($content as $mainKey => $values) {
        if(is_array($values)) {
          $result[$mainKey] = self::sanitize($values);
        }
        else {
          $result[$mainKey] = self::sanitizeString((string) $values);
        }
      }
    }
    else {
      throw new Exception('CMS_Controller_Web::sanitize can\'t handle content of type '.gettype($content));
    }

    return $result;
  }

  /**
   * Checks for user permissions
   *
   * @param string $permissionName
   * @return boolean
   */
  public function hasPermission ($permissionName) {
    return true;
  }
}
?>