<?php
if(!function_exists('get_microtime')) {
	function get_microtime () {
		// returns the current time
		list($usec, $sec) = explode(" ", microtime());
		return ((float)$usec + (float)$sec);
	}
}

define('START_TIME', get_microtime());

require_once 'local.inc';

require_once 'Zend/Db.php';

require_once 'Zend/Log.php';
require_once 'Zend/Log/Adapter/File.php';
require_once 'Zend/Log/Adapter/Console.php';

define('DEFAULT_LOCALE', 'en');
define('JOIN_DELIMITER', ', ');

/**
 * Datenbank-Objekt
 */
$db = Zend_Db::factory(DB_PDO, $db_params);
$db->query('SET NAMES utf8');

Zend::register('default_db', $db);

$logMsgPrefix = date('d.m.Y H:i:s').' - ';
Zend_Log::registerLogger(new Zend_Log_Adapter_File(ERROR_LOG_PATH), 'File');
Zend_Log::setMessagePrefix($logMsgPrefix, 'File');
Zend_Log::registerLogger(new Zend_Log_Adapter_Console(), 'Console');
Zend_Log::setMessagePrefix($logMsgPrefix, 'Console');
Zend_Log::setDefaultLogger(LOG_DEFAULT_ADAPTER);

define('RCD_no_contact',0);
define('RCD_sent',1);
define('RCD_received',2);
define('RCD_in_contact',3);
define('RCD_rejected',4);
?>