<?php
include ("jpgraph/jpgraph.php");
include ("jpgraph/jpgraph_scatter.php");

class SearchGraph {
  /**
   * JPGraph Graph Object
   *
   * @var Graph
   */
  protected $graph;

  function __construct($width=600, $height=400) {
    $this->graph = new Graph(600,400,"auto");
    $this->graph->SetScale("linlin",-20,20,-10,10);
    $this->graph->img->SetMargin(40,120,40,40);	// left,right,top,bottom
    $this->graph->SetShadow();
  }

  function setTitle($head) {
    $this->graph->title->Set($head);
    $this->graph->title->SetFont(FF_FONT1,FS_BOLD);
  }

  function setXAxisTitle($title) {
    $this->graph->xaxis->SetTitle($title,'middle');
    $this->graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);
    $this->graph->xaxis->SetTitlemargin(155);
  }

  function setYAxisTitle($title) {
    $this->graph->yaxis->SetTitle($title,'middle');
    $this->graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD);
    $this->graph->yaxis->SetTitlemargin(230);
  }

  protected function randomize($origValue, $randomizer=0.33) {
    $res = $origValue;
    $rnd = rand(1,10);
    if($rnd<3) $res -= $randomizer;
    elseif($rnd>7) $res += $randomizer;
    return $res;
  }

  protected function doPlot($arr, $type, $color, $width, $legend) {
    $x = array();
    $y = array();
    foreach($arr AS $uid=>$coords) {
      // build arrays in the form that jpgraph needs and
      // also randomized add/substract 0.33 from x or y
      $x[] = $this->randomize($coords['x']);
      $y[] = $this->randomize($coords['y']);
    }
    $sp1 = new ScatterPlot($y,$x);
    $sp1->mark->SetType($type);
    $sp1->mark->SetFillColor($color);
    $sp1->mark->SetWidth($width);
    $sp1->SetLegend($legend);
    $this->graph->Add($sp1);
  }

  function plotMySelf($x,$y) {
    $arr = array(array('x'=>$x,'y'=>$y));
    $this->doPlot($arr, MARK_FILLEDCIRCLE, "blue", 8, "You");
  }

  function plotNoContact($arr) {
    $this->doPlot($arr, MARK_X, "black", 5, "No Contact");
  }

  function plotRCDSent($arr) {
    $this->doPlot($arr, MARK_FILLEDCIRCLE, "red", 4, "RCD sent");
  }

  function plotInContact($arr) {
    $this->doPlot($arr, MARK_FILLEDCIRCLE, "green", 4, "In Contact");
  }

  function plotRCDReceived($arr) {
    $this->doPlot($arr, MARK_FILLEDCIRCLE, "violet", 4, "RCD received");
  }

  function output() {
    $this->graph->legend->Pos(0.02,0.5,"right","center");
    $this->graph->Stroke();
  }
}
?>