<?php

/**
 * class to encapsulate the core logic of the TTT calculation
 *
 */
class TTT {
  // different aspects of MBTI Model
  // Positive Values express a precidence for the first character, negative for the second
  protected $ei=0;
  protected $sn=0;
  protected $tf=0;
  protected $jp=0;
  static $keirseyType = array('SJ'=>'Guardian',
                              'SP'=>'Artisan',
                              'NT'=>'Rational',
                              'NF'=>'Idealist');
  static $mbtiType = array(
      "ISTJ" => 1,
      "ISFJ" => 2,
      "INFJ" => 3,
      "INTJ" => 4,
      "ISTP" => 5,
      "ISFP" => 6,
      "INFP" => 7,
      "INTP" => 8,
      "ESTP" => 9,
      "ESFP" => 10,
      "ENFP" => 11,
      "ENTP" => 12,
      "ESTJ" => 13,
      "ESFJ" => 14,
      "ENFJ" => 15,
      "ENTJ" => 16
    );

  /**
   * Constructor for TTT Object
   */
  function __construct($ei=0,$sn=0,$tf=0,$jp=0) {
    $this->ei = $ei;
    $this->sn = $sn;
    $this->tf = $tf;
    $this->jp = $jp;
  }

  function addE($cnt=1) {
    $this->ei += $cnt;
  }

  function addS($cnt=1) {
    $this->sn += $cnt;
  }

  function addT($cnt=1) {
    $this->tf += $cnt;
  }

  function addJ($cnt=1) {
    $this->jp += $cnt;
  }

  function addI($cnt=1) {
    $this->ei -= $cnt;
  }

  function addN($cnt=1) {
    $this->sn -= $cnt;
  }

  function addF($cnt=1) {
    $this->tf -= $cnt;
  }

  function addP($cnt=1) {
    $this->jp -= $cnt;
  }

  /**
   * retruns string of Type "E+2S+1F+2P+1"
   *
   * @return String
   */
  function getTTType() {
    if($this->ei<=0) $ei = 'I+'.abs($this->ei);
    else $ei = 'E+'.abs($this->ei);
    if($this->sn>=0) $sn = 'S+'.abs($this->sn);
    else $sn = 'N+'.abs($this->sn);
    if($this->tf>=0) $tf = 'T+'.abs($this->tf);
    else $tf = 'F+'.abs($this->tf);
    if($this->jp>=0) $jp = 'J+'.abs($this->jp);
    else $jp = 'P+'.abs($this->jp);
    return "$ei$sn$tf$jp";
  }

  /**
   * Returns string of type "ESFP"
   *
   * @return unknown
   */
  function getMBTIType() {
    if($this->ei<=0) $res = 'I';
    else $res = 'E';
    if($this->sn>=0) $res .= 'S';
    else $res .= 'N';
    if($this->tf>=0) $res .= 'T';
    else $res .= 'F';
    if($this->jp>=0) $res .= 'J';
    else $res .= 'P';
    return $res;
  }

  /**
   * Maps MBTI Types to Numeric Number between 1 and 16
   *
   * @return Int
   */
  function getMBTITypeNumeric() {
    return self::$mbtiType[$this->getMBTIType()];
  }

  function getKeirseyType() {
    $mbtiType = $this->getMBTIType();
    if($mbtiType[1]=='S') {
      if($mbtiType[3]=='J') $res = 'SJ';
      if($mbtiType[3]=='P') $res = 'SP';
    }
    if($mbtiType[1]=='N') {
      if($mbtiType[2]=='T') $res = 'NT';
      if($mbtiType[2]=='F') $res = 'NF';
    }
    return $res;
  }

  /**
   * return the raw data of the calculated values
   *
   * @return array
   */
  function getRawData() {
    return array('EI'=>$this->ei, 'SN'=>$this->sn, 'TF'=>$this->tf, 'JP'=>$this->jp);
  }
}
