<?php

/**
 * Represents one Question in the TTT questionaire
 *
 */
class TTTQuestion {
  public $question;
  public $answers = array(); 
}

/**
 * Ready all Questions from ttt_questions.txt and stores them
 * as TTTQuestion objects in an array
 *
 */
class TTTQuestions {
  /**
   * Array of TTQuestion Objects
   *
   * @var array
   */
  public $questions = array();
  
  function __construct($filename='ttt-questions.txt') {
    $fp = fopen($filename,'r',true);
    if(!$fp) throw new Exception('cannot open ttt-questions.txt');
    
    $line = fgets($fp);
    while (!feof($fp)) {
      $question = new TTTQuestion();
      $question->question = $line; 
      while (!feof($fp) && trim($line = fgets($fp))!='') {
         $question->answers[] = explode(':',$line);
      } 
      $this->questions[] = $question;
      while (!feof($fp) && trim($line = fgets($fp))=='');
    }
    fclose($fp);
  }
}

//$q = new TTTQuestions('ttt-questions.txt');
