<?php

/**
 * @author 	   Michael Mayer <michael.mayer@zend.com>
 */

/** MultilangModel */
require_once('models/MultilangModel.php');

/** D100_Container */
require_once('D100/Container.php');

include_once('GEOCode.php');

/**
 * Users class which does all the complex queries for us
 */
class UsersModel extends MultilangModel {
  public static function getAllUsers () {
    $db = self::getDbObject();

    $select = $db->select();

    $select->from('users', '*');
    $select->order('user_name');

    return $db->fetchAll($select);
  }

  public function countUsers(Array $container) {

    // foreach(ceil($))
  }


  public static function searchUsers (Array $container, $userId = null, $page = null) {
    $db = self::getDbObject();

    if(!is_numeric($page)) {
      $page = 0;
    }

    $limit = 'LIMIT '.(100*$page).', 100';

    $where = '';
    $having = '';
    $extraSelect = '';

    if(isset($container['ttt']) && is_array($container['ttt']) && count($container['ttt'])) {
      $ttt = array();

      foreach($container['ttt'] as $key => $value) {
        if($value == 1) {
          $ttt[] = $key;
        }
      }

      if(count($ttt) > 0) {
        $where = $db->quoteInto(' AND mbti_type IN (?) ', $ttt);
      }
    }

    if(isset($container['motto']) && $container['motto'] != '') {
      $where .= $db->quoteInto(' AND life_motto LIKE ?', '%'.$container['motto'].'%');
    }

    if(isset($container['only_tested']) && $container['only_tested'] == 1) {
      $where .= ' AND SN IS NOT NULL ';
    }

    if(isset($container['lat']) && isset($container['long']) && is_numeric($container['distance']) && $container['distance'] > 1) {
      $extraSelect = ', '.GEOCode::generateSelectClause($container['lat'],$container['long']);
      $having = ' HAVING distance >= '.$container['distance'];
    }

    if($where == '') {
      return false;
    }

    if(!is_numeric($userId)) {
      $sql = "SELECT *, NULL as contact_status, NULL as status_id FROM users WHERE user_name IS NOT NULL $where ORDER BY user_name $limit";
    }
    elseif($container['not_contact']) {
      $sql = "SELECT a.*, NULL as contact_status, NULL as status_id $extraSelect
FROM users a
WHERE a.user_id <> $userId AND NOT
EXISTS (

SELECT *
FROM rcd
WHERE (
rcd.user_id = $userId
AND rcd.to_user_id = a.user_id
)
OR (
rcd.to_user_id = $userId
AND rcd.user_id = a.user_id
)
) $where $having ORDER BY user_name $limit";

    } else {


      $sql = "(SELECT a.*, 'TO' as contact_status, b.status_id $extraSelect FROM users a JOIN rcd b ON a.user_id = b.user_id WHERE a.user_id <> $userId AND b.to_user_id = $userId $where $having)
UNION
(SELECT a.*, 'FROM' as contact_status, b.status_id $extraSelect FROM users a JOIN rcd b ON a.user_id = b.to_user_id WHERE a.user_id <> $userId AND b.user_id = $userId $where $having)
UNION
(SELECT a.*, NULL as contact_status, NULL as status_id $extraSelect
FROM users a
WHERE a.user_id <> $userId AND NOT
EXISTS (

SELECT *
FROM rcd
WHERE (
rcd.user_id = $userId
AND rcd.to_user_id = a.user_id
)
OR (
rcd.to_user_id = $userId
AND rcd.user_id = a.user_id
)
) $where $having)  ORDER BY user_name $limit";

    }

    $results = $db->fetchAll($sql);

    if(empty($results)) {
      return array();
    }
    else {
      return $results;
    }
  }

}
?>