<?php

require_once('Zend.php');
require_once('D100/Template/SectionIterator.php');

class NavigationSection extends D100_Template_SectionIterator {

  private $res = array();

  public function init(D100_Template_ValueObject $valueObject) {
    $iniFile = parse_ini_file('include/'.basename($valueObject->nav).'.ini', true);

    $locale = isset($iniFile[$valueObject->locale]) ? $valueObject->locale : 'en';

    foreach ($iniFile[$locale] as $key => $value) {
      if(strpos($key, '_') === 0 && $class == 'selected') {
        $subClass = (strpos($key, '/'.$valueObject->action) !== FALSE) ? 'subSelected' : 'subNormal';
        $this->res[] = array('path' => substr($key, 1), 'label' => $value, 'class' => $subClass);
      } elseif(strpos($key, '_') == (strlen($key) - 1)) {
        $class = (strpos(strrev($key), strrev($valueObject->action)) == 1) ? 'selected' : 'normal';
        $this->res[] = array('path' => substr($key, 0, -1), 'label' => $value, 'class' => $class);
      } elseif(strpos($key, '_') !== 0) {
        $class = (strpos($key, $valueObject->current) === 0) ? 'selected' : 'normal';
        $this->res[] = array('path' => $key, 'label' => $value, 'class' => $class);
      }
    }

    reset($this->res);
  }

  public function fetchRow() {
    $nextValue = current($this->res);
    next($this->res);
    return $nextValue;
  }
}
?>