<?php

require_once('Zend.php');
require_once('D100/Template/SectionIterator.php');

class RCDListSection extends D100_Template_SectionIterator {

  private $rcdList;

  public function init(D100_Template_ValueObject $valueObject) {
    $userId = $valueObject->userId;
    if($userId <=0) throw new Exception("Fatal: property 'user_id' found in given valueObject");
    $status = $valueObject->status;
    
    $userMod = UserModel::getInstance($userId);
    $this->rcdList = $userMod->getRCDUsers($status);
  }

  public function fetchRow() {
    if(!$this->rcdList) return false;
    $currRow = current($this->rcdList);
    
    next($this->rcdList);
    
    return $currRow;
  }
}
?>