<?php

require_once('D100/Template/SectionIterator.php');
require_once('models/UserModel.php');
require_once('ttt.php');

/**
 * Displays the user's detail specified with the sectionparameter 'user_id'.
 *
 */
class UserDetailSection extends D100_Template_SectionIterator {
  /**
   * @var UserModel
   */
  private $userModel;

  public function init(D100_Template_ValueObject $valueObject) {
    $this->setModeOnlyOnce();
    if($valueObject->userId <=0) throw new Exception("Fatal: property 'user_id' found in given valueObject");
    $this->userModel = UserModel::getInstance($valueObject->userId);
  }

  public function fetchRow() {
    $values = $this->userModel->getValues();
    if($values['mbti_timestamp']) $values['mbti_timestamp'] = date("Y/m/d H:i", $values['mbti_timestamp']);

    $ttt = new ttt($values['ei'],$values['sn'],$values['tf'],$values['jp']);
    $values['keirsey_type'] = $ttt->getKeirseyType();

    if(Auth::getInstance()->getLoggedUser()->getId() == $this->userModel->getId()) {
      $values['is_logged_user'] = true;
    }

    return $values;
  }
}
?>