<?php

require_once 'include/config.inc';

require_once 'Zend/Db.php';
require_once 'Zend/Db/Table.php';
require_once 'Zend/Controller/Front.php';
require_once 'D100/Controller/Web.php';
require_once 'D100/Controller/Dispatcher.php';

require_once 'Platforms/Controller/Web.php';
require_once 'models/LogModel.php';
require_once 'AuthControllerPlugin.php';

/**
 * Default exceptionHandler. handles all uncaght exceptions
 *
 * @param Exception $e
 */
function cms_defaultExceptionHandler($e) {
  $msg = $e->getMessage()."\n".$e->getTraceAsString();

  try {
    Zend_Log::log($msg, ((DEBUG) ? Zend_Log::LEVEL_DEBUG : Zend_Log::LEVEL_WARNING));
  }
  catch(Exception $e) {
    die('FATAL: exception while logging: '.$e->getMessage());
  }

  $errorPage = strtr(file_get_contents(PROJECT_BASE_PATH.'/htdocs/error.html'), array('%%error%%' => $e->getMessage()));

  die($errorPage);
}

set_exception_handler('cms_defaultExceptionHandler');

function cms_queryLogger() {
  if(!SQLLOG || !DEBUG) return;
  $profiler = Zend::registry('default_db')->getProfiler();
  if($profiler->getEnabled()) {
    $queries = $profiler->getQueryProfiles();
    if(is_array($queries) && count($queries) > 0) {
      $logMsgPrefix = date('d.m.Y H:i:s').' - ';
      $total = round($profiler->getTotalElapsedSecs() * 1000, 2);
      $num = $profiler->getTotalNumQueries();
      Zend_Log::log("$logMsgPrefix num queries [$num], total querytime [$total] ms", Zend_Log::LEVEL_DEBUG);
      foreach($queries as $queryObj) {
        $q = ereg_replace("\n", " ", $queryObj->getQuery());
        $pieces = explode(" ", $q);
        foreach($pieces as $k => $token) $pieces[$k] = trim($token);
        $q = implode(' ', $pieces);
        Zend_Log::log("  ".$q, Zend_Log::LEVEL_DEBUG);
      }
    }
  }
}

// Zend_Db_Table::setDefaultAdapter(Zend::registry('default_db'));
define('LOAD_TIME', get_microtime());
$log = LogModel::getInstance();
D100_Controller_Web::setViewDir(APP_PATH.'/views');

$c = Zend_Controller_Front::getInstance();
$d = new D100_Controller_Dispatcher();
$c->setDispatcher($d);
$c->registerPlugin(new AuthControllerPlugin());
$c->setControllerDirectory(CONTROLLER_DIR);
$c->dispatch();
$log->save();

cms_queryLogger();
?>