/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.core.model;

import org.platforms.contest.core.model.internal.db.FakeDB;


public final class Model {

  private static FakeDB persistentStore;
  
  // create some mockup data
  static {
    persistentStore = new FakeDB();
    IUser fritz = ModelObjectFactory.createUser();
    fritz.setLoginName( "fritz" );
    fritz.setFullname( "Fritz von Fratz" );
    fritz.setEMail( "fritz@nowhere.com" );
    fritz.setMotto( "Come to where the fritz is." );
    fritz.setCountry( "Germany" );
    fritz.setTown( "Bielefeld" );
    Model.save( fritz );
    
    IUser egon = ModelObjectFactory.createUser();
    egon.setLoginName( "egon" );
    egon.setFullname( "Egon Olsen" );
    egon.setEMail( "egon@olsenanden.dk" );
    egon.setCountry( "Denmark" );
    Model.save( egon );
    
    IUser maria = ModelObjectFactory.createUser();
    maria.setLoginName( "maria" );
    maria.setFullname( "Maria" );
    Model.save( maria );
    
    IUser pudel = ModelObjectFactory.createUser();
    pudel.setLoginName( "pudel" );
    pudel.setFullname( "Herr Pudel" );
    Model.save( pudel );
    
    IUser sascha = ModelObjectFactory.createUser();
    sascha.setLoginName( "sascha" );
    sascha.setFullname( "Sascha" );
    Model.save( sascha );
    
    Model.sendRCD( fritz, egon );
    Model.sendRCD( maria, fritz );
    
    Model.sendRCD( fritz, sascha );
    Model.confirmRCD( sascha, fritz );
  }
  
  
  public static void setPersistentStore( final FakeDB store ) {
    if( store != null ) {
      store.close();
    }
    Model.persistentStore = store;
  }
  
  private Model() {
    // prevent instantiation
  }

  public static void save( final IUser user ) {
    Model.persistentStore.save( user );
  }

  public static void sendRCD( final IUser user, IUser toUser ) {
    Model.persistentStore.sendRCD( user, toUser );
  }

  public static void confirmRCD( final IUser receivingUser, 
                                 final IUser sendingUser ) 
  {
    Model.persistentStore.confirmRCD( receivingUser, sendingUser );
  }

  public static IUser findByLoginName( final String loginName ) {
    return Model.persistentStore.findByLoginName( loginName );
  }
  
  public static IUser[] findSent( final IUser user ) {
    return Model.persistentStore.findSent( user );
  }
  
  public static IUser[] findReceived( final IUser user ) {
    return Model.persistentStore.findReceived( user );
  }
  
  public static IUser[] findInContact( final IUser user ) {
    return Model.persistentStore.findInContact( user );
  }
  
  public static IUser[] search( final IUser user, 
                                final SearchCriterias criterias ) 
  {
    return Model.persistentStore.search( user, criterias );
  }
}
