/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.core.model;

import org.platforms.contest.core.model.internal.*;


public final class ModelObjectFactory {
  
  private ModelObjectFactory() {
    // prevent instantiation
  }
  
  public static IUser createUser() {
    User result = new User();
    result.setId( IdGenerator.create() );
    return result;
  }
  
  public static ITTT createTTT( final IUser user ) {
    TTT result = new TTT();
    result.setId( IdGenerator.create() );
    User userImpl = ( User )user;
    userImpl.setTTT( result );
    return result;
  }
}
