/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.core.model.internal;

import java.util.*;


public final class ContactState {

  public static final ContactState IN_CONTACT 
    = new ContactState( "IN_CONTACT" );
  public static final ContactState RCD_SENT
    = new ContactState( "RCD_SEND" );
  public static final ContactState NO_CANTACT
    = new ContactState( "NO_CONTACT" );

  private static int nextOrdinal;
  private final static ContactState[] values = new ContactState[] {
    IN_CONTACT,
    RCD_SENT,
    NO_CANTACT
  };
  
  public static final List VALUES 
    = Collections.unmodifiableList( Arrays.asList( values ) );
  
  private final String name;
  private final int ordinal;

  
  public ContactState( final String typeName ) {
    this.name = typeName;
    this.ordinal = nextOrdinal++;
  }
  
  public String toString() {
    return name;
  }

  public int compareTo( final Object toCompare ) {
    return this.ordinal - ( ( ContactState )toCompare ).ordinal;
  }

  public int getOrdinal() {
    return ordinal;
  }
}
