/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.core.model.internal;

import org.platforms.contest.core.model.ITTT;

public class TTT extends ModelObject implements ITTT {

  private int valueEI = 0;
  private int valueSN = 0;
  private int valueTF = 0;
  private int valueJP = 0;  
  
  public void clear() {
    valueEI = 0;
    valueSN = 0;
    valueTF = 0;
    valueJP = 0;  
  }

  public void add( int dimension, int value ) {
    if( dimension == DIM_EI ) {
      valueEI += value;
    } else if (dimension == DIM_SN ) {
      valueSN += value;
    } else if (dimension == DIM_TF ) {
      valueTF += value;
    } else if (dimension == DIM_JP ) {
      valueJP += value;
    }
  }

  public int getEI() {
    return valueEI;
  }
  
  public int getJP() {
    return valueJP;
  }
  
  public int getSN() {
    return valueSN;
  }
  
  public int getTF() {
    return valueTF;
  }

  public void setEI( int valueEI ) {
    this.valueEI = valueEI;
  }
  
  public void setJP( int valueJP ) {
    this.valueJP = valueJP;
  }
  
  public void setSN( int valueSN ) {
    this.valueSN = valueSN;
  }
  
  public void setTF( int valueTF ) {
    this.valueTF = valueTF;
  }
  
  public String toString() {
    StringBuffer sb = new StringBuffer();
    sb.append( ( valueEI >= 0 ? "E+" + valueEI : "I+" + -valueEI ) + ", ");
    sb.append( ( valueSN >= 0 ? "S+" + valueSN : "N+" + -valueSN ) + ", ");
    sb.append( ( valueTF >= 0 ? "T+" + valueTF : "F+" + -valueTF ) + ", ");
    sb.append( ( valueJP >= 0 ? "J+" + valueJP : "P+" + -valueJP ) );
    return sb.toString();
  }
}
