/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.core.model.internal;

import org.platforms.contest.core.model.ITTT;
import org.platforms.contest.core.model.IUser;


public class User extends ModelObject implements IUser {

  private String loginName = "";
  private String password = "";
  private String eMail = "";
  private String motto = "";
  private String country = "";
  private String town = "";
  private String fullname = "";
  private ITTT ttt;
  private String tttId;

  ///////////////////////
  // IUser implementation
  
  public String getLoginName() {
    return loginName;
  }
  
  public void setLoginName( final String loginName ) {
    this.loginName = loginName;
  }
  
  public String getEMail() {
    return eMail;
  }

  public void setEMail( final String eMail ) {
    this.eMail = eMail;
  }
  
  public String getPassword() {
    return password;
  }

  public void setPassword( final String password ) {
    this.password = password;
  }

  public String getCountry() {
    return country;
  }
  
  public void setCountry( String country ) {
    this.country = country;
  }
  
  public String getFullname() {
    return fullname;
  }
  
  public void setFullname( String fullname ) {
    this.fullname = fullname;
  }
  
  public String getMotto() {
    return motto;
  }
  
  public void setMotto( String motto ) {
    this.motto = motto;
  }
  
  public String getTown() {
    return town;
  }

  public void setTown( String town ) {
    this.town = town;
  }

  public ITTT getTTT() {
    return ttt;
  }
  
  public void setTTT( final ITTT ttt ) {
    this.ttt = ttt;
    if( ttt == null ) {
      tttId = null;
    } else {
      TTT tttImpl = ( TTT )ttt;
      this.tttId = tttImpl.getId();
    }
  }
  
  public String getTTTId() {
    return tttId;
  }
}
