/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.core.model.internal;

import org.platforms.contest.core.model.IUser;


public class UserRelation extends ModelObject {
  
  private String senderId;
  private String receiverId;
  private ContactState contactState;
  
  public UserRelation() {
    setId( IdGenerator.create() );
  }

  public String getSenderId() {
    return senderId;
  }
  
  public void setSenderId( final String senderId ) {
    this.senderId = senderId;
  }

  public String getReceiverId() {
    return receiverId;
  }
  
  public void setReceiverId( final String receiverId ) {
    this.receiverId = receiverId;
  }
  
  public ContactState getContactState() {
    return contactState;
  }
  
  public void setContactState( final ContactState contactState ) {
    this.contactState = contactState;
  }
  
  public String getContactFor( final IUser user ) {
    String result = null;
    String userId = ( ( User )user ).getId();
    if( senderId.equals( userId ) ) {
      result = receiverId;
    } else if( receiverId.equals( userId ) ) {
      result = senderId;
    }
    return result;
  }
}
