/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.core.model.internal.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;
import org.platforms.contest.core.model.*;
import org.platforms.contest.core.model.internal.*;

/*
 * NOTE: 
 * This is the unfinished replacement for FakeDB. It is not yet in use.
 * Once it successfully completes the test cases, an interface from this
 * class an FakeDB can be extracted and Model#setPersistenceStore can
 * be used to switch between the 'real' storage facility and the fake (in
 * memory) one.
 */
public final class HsqlDB {
  
  private static final String USER_COLUMN_LIST_U 
    = "u.id, u.login_name, u.password, u.email, u.country, u.full_name, " 
    + "u.motto, u.town ";

  private static final String USER_COLUMN_LIST 
    = "id, login_name, password, email, country, full_name, motto, town";

  private static final String UPDATE_CONTACT_SET_CONTACT_STATE 
    = "UPDATE contact SET contact_state = ? " 
    + "WHERE sender_id = ? AND receiver_id = ?;";
  private static final String INSERT_CONTACT 
    = "INSERT INTO contact ( id, sender_id, receiver_id, contact_state ) " 
    + "VALUES ( ?, ?, ?, ? );";
  private static final String UDPATE_TTT 
    = "UDPATE ttt SET ei = ?, sn = ?, tf = ?, jp = ? WHERE id = ?;";
  private static final String INSERT_TTT 
     = "INSERT INTO ttt ( id, user_id, ei, sn, tf, jp  ) " 
     + "VALUES ( ?, ?, ?, ?, ?, ? );";
  private static final String SELECT_TTT 
    = "SELECT * FROM ttt WHERE user_id = ?;";
  private static final String SELECT_USER 
    = "SELECT " + USER_COLUMN_LIST 
    + " FROM user WHERE login_name = ?;";
  private static final String UPDATE_USER 
    = "UPDATE user SET login_name = ?, password = ?, email = ? WHERE id = ?;";
  private static final String INSERT_USER 
    = "INSERT INTO user ( id, login_name, password, email ) " 
    + "VALUES ( ?, ?, ?, ? );";
  // key: id, value: User
  private final Map users = new HashMap(); 
  // key: id, value: UserRelation
  private final Map userRelations = new HashMap();
  // key: id, value: TTT
  private final Map ttts = new HashMap();

  ///////////////////////////////////////////////////////////////
  // Internal classes to convert resultSet rows to model objects
  
  private static final class UserResultMapper implements IResultMapper {
    public Object mapRow( final ResultSet resultSet ) throws SQLException {
      User result = new User();
      result.setId( resultSet.getString( "id" ) );
      result.setLoginName( resultSet.getString( "login_name" ) );
      result.setPassword( resultSet.getString( "password" ) );
      result.setEMail( resultSet.getString( "email" ) );
      return result;
    }
  }

  private static final class TTTResultMapper implements IResultMapper {
    public Object mapRow( final ResultSet resultSet ) throws SQLException {
      TTT result = new TTT();
      result.setId( resultSet.getString( "id" ) );
      result.setEI( resultSet.getInt( "ei" ) );
      result.setSN( resultSet.getInt( "sn" ) );
      result.setJP( resultSet.getInt( "jp" ) );
      result.setTF( resultSet.getInt( "tf" ) );
      return result;
    }
  }
  
  ///////////////////
  // Mutating methods
  
  public void save( final IUser user ) {
    int count = SqlUtil.count( "user", getId( user ) );
    if( count == 0 ) {
      Object[] args = new Object[] { 
        getId( user ), 
        user.getLoginName(), 
        user.getPassword(), 
        user.getEMail() 
      };
      SqlUtil.execute( INSERT_USER, args );
    } else {
      Object[] args = new Object[] { 
        user.getLoginName(),
        user.getPassword(),
        user.getEMail(),
        getId( user )
      };
      SqlUtil.execute( UPDATE_USER, args );
    }
    TTT ttt = ( TTT )user.getTTT();
    if( ttt != null ) {
      TTT tttEntity = copy( ttt );
      ttts.put( tttEntity.getId(), tttEntity );
      count = SqlUtil.count( "ttt", getId( ttt ) );
      if( count == 0 ) {
        Object[] args = new Object[] {
          getId( ttt ),
          getId( user ),
          new Integer( ttt.getEI() ),
          new Integer( ttt.getSN() ),
          new Integer( ttt.getTF() ),
          new Integer( ttt.getJP() )
        };
        SqlUtil.execute( INSERT_TTT, args );
      } else {
        Object[] args = new Object[] {
          new Integer( ttt.getEI() ),
          new Integer( ttt.getSN() ),
          new Integer( ttt.getTF() ),
          new Integer( ttt.getJP() ),
          getId( ttt )
        };
        SqlUtil.execute( UDPATE_TTT, args );
      }
    }
  }

  public void sendRCD( final IUser sendingUser, final IUser receivingUser ) {
    Object[] args = new Object[] { 
      ContactState.RCD_SENT, 
      getId( receivingUser ), 
      getId( sendingUser ), 
      getId( sendingUser ), 
      getId( receivingUser ) 
    };
    String sql 
      = "SELECT COUNT( * ) FROM contact " 
      + "WHERE contact_state = ? AND " 
      + "( ( sender_id = ? AND receiver_id = ? ) OR ( sender_id = ? AND receiver_id = ? ) );";
    int count = SqlUtil.count( sql, args );
    if( count > 0 ) {
      confirmRCD( sendingUser, receivingUser );
    } else {
      args = new Object[] { 
        IdGenerator.create(), 
        getId( sendingUser ), 
        getId( receivingUser ), 
        ContactState.RCD_SENT 
      };
      SqlUtil.execute( INSERT_CONTACT, args );
    }
  }
  
  public void confirmRCD( final IUser receivingUser, final IUser sendingUser ) {
    Object[] args = new Object[] { 
      ContactState.IN_CONTACT, 
      getId( sendingUser ), 
      getId( receivingUser ), 
    };
    SqlUtil.execute( UPDATE_CONTACT_SET_CONTACT_STATE, args );
  }
  
  ///////////////
  // Find methods
  
  public IUser findByLoginName( final String loginName ) {
    IResultMapper mapper = new UserResultMapper();
    Object[] args = new Object[] { loginName };
    Object[] users = SqlUtil.query( SELECT_USER, args, mapper );
    User result = null;
    if( users.length > 0 ) {
      result = ( User )users[ 0 ];
      args = new Object[] { result.getId() };
      Object[] ttts = SqlUtil.query( SELECT_TTT, args, new TTTResultMapper() );
      if( ttts.length > 0 ) {
        result.setTTT( ( ITTT )ttts[ 0 ] );
      }
    }
    return result;
  }
  
  public IUser[] findSent( final IUser user ) {
    User userImpl = ( User )user;
    String userId = userImpl.getId();
    List inContact = new ArrayList();
    Iterator iter = userRelations.values().iterator();
    while( iter.hasNext() ) {
      UserRelation userRelation = ( UserRelation )iter.next();
      if(    userRelation.getContactState().equals( ContactState.RCD_SENT ) 
          && userRelation.getSenderId().equals( userId ) ) 
      {
        inContact.add( findUserById( userRelation.getContactFor( userImpl ) ) );
      }
    }
    IUser[] result = new IUser[ inContact.size() ];
    inContact.toArray( result );
    return result;
  }
  
  public IUser[] findReceived( final IUser user ) {
    User userImpl = ( User )user;
    String userId = userImpl.getId();
    List inContact = new ArrayList();
    Iterator iter = userRelations.values().iterator();
    while( iter.hasNext() ) {
      UserRelation userRelation = ( UserRelation )iter.next();
      if(    userRelation.getContactState().equals( ContactState.RCD_SENT ) 
          && userRelation.getReceiverId().equals( userId ) ) 
      {
        inContact.add( findUserById( userRelation.getContactFor( userImpl ) ) );
      }
    }
    IUser[] result = new IUser[ inContact.size() ];
    inContact.toArray( result );
    return result;
  }

  public IUser[] findInContact( final IUser user ) {
    Object[] args = new Object[] {
      ContactState.IN_CONTACT,
      getId( user ),
      ContactState.IN_CONTACT,
      getId( user )
    };
    String sql 
      = "SELECT " 
      + USER_COLUMN_LIST_U 
      + "FROM user u "
      + "INNER JOIN contact c ON c.receiver_id = u.id "
      + "WHERE c.contact_state = ? AND c.sender_id = ? "
      + "UNION SELECT "
      + USER_COLUMN_LIST_U 
      + "FROM user u "
      + "INNER JOIN contact c ON c.sender_id = u.id "
      + "WHERE c.contact_state = ? AND c.receiver_id = ?;";
    Object[] resultSet = SqlUtil.query( sql, args, new UserResultMapper() );
    User[] result = new User[ resultSet.length ];
    for( int i = 0; i < resultSet.length; i++ ) {
      result[ i ] = ( User )resultSet[ i ];
    }
    return result;
  }

  public IUser[] search( final IUser user, final SearchCriterias criterias ) {
    User[] result = new User[ 0 ];
    // TODO [rh] only one search criteria currently implemented
    if( criterias != null ) {
      Object[] args = new Object[] {
        ContactState.IN_CONTACT,
        ContactState.IN_CONTACT,
        getId( user )
      };
      String sql 
        = "SELECT " 
        + USER_COLUMN_LIST_U 
        + "FROM user u "
        + "INNER JOIN contact c ON c.receiver_id = u.id "
        + "WHERE c.contact_state != ? AND c.sender_id = ? "
        + "UNION DISTINCT SELECT "
        + USER_COLUMN_LIST_U 
        + "FROM user u "
        + "INNER JOIN contact c ON c.sender_id = u.id "
        + "WHERE c.contact_state != ? AND c.receiver_id = ?";
//        + "UNION DISTINCT SELECT "
//        + USER_COLUMN_LIST_U 
//        + "FROM user u " 
//        + "WHERE " 
//        + "NOT EXISTS ( SELECT 1 FROM contact c WHERE c.sender_id = u.id ) "
//        + "AND " 
//        + "NOT EXISTS ( SELECT 1 FROM contact c WHERE c.receiver_id = u.id ) ";
      Object[] query = SqlUtil.query( sql, args, new UserResultMapper() );
      result = new User[ query.length ];
      for( int i = 0; i < query.length; i++ ) {
        result[ i ] = ( User )query[ i ];
      }
    }
    return result;
  }

  public boolean isInContact( final IUser user1, final IUser user2 ) {
    boolean result = false;
    String user1Id = getId( user1 );
    String user2Id = getId( user2 );
    Iterator iter = userRelations.values().iterator();
    while( !result && iter.hasNext() ) {
      UserRelation userRelation = ( UserRelation )iter.next();
      String receiverId = userRelation.getReceiverId();
      String senderId = userRelation.getSenderId();
      if(    userRelation.getContactState().equals( ContactState.IN_CONTACT ) 
          && (    ( senderId.equals( user2Id ) && receiverId.equals( user1Id ) )
               || ( senderId.equals( user1Id ) && receiverId.equals( user2Id ) ) ) )
      {
        result = true;
      }
    }
    return result;
  }

  public void close() {
    SqlUtil.closeConnection();
  }
  
  private IUser findUserById( final String id ) {
    return ( IUser )users.get( id );
  }
  
  private TTT copy ( final TTT ttt ) {
    TTT result = null;
    if( ttt != null ) {
      result = new TTT();
      result.setId( ttt.getId() );
    }
    return result;
  }
  
  private static String getId( final IUser user ) {
    User userImpl = ( User )user;
    return userImpl.getId();
  }

  private static String getId( final ITTT ttt ) {
    TTT tttImpl = ( TTT )ttt;
    return tttImpl.getId();
  }
}
