/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.middle;

import java.util.HashSet;
import java.util.Set;
import org.platforms.contest.core.model.*;
import com.w4t.SessionSingletonBase;


public class SessionModel extends SessionSingletonBase {
  
  private static final IUser[] EMPTY_RESULT = new IUser[ 0 ];
  private IUser user;
  private Set listeners = new HashSet();
  
  private SessionModel() {
    // prevent instantiation
  }
  
  public static SessionModel getInstance() {
    return ( SessionModel )getInstance( SessionModel.class );
  }
  
  public static IUser findByLoginName( final String loginName ) {
    return Model.findByLoginName( loginName );
  }
  
  public static IUser[] findSent() {
    IUser[] result = EMPTY_RESULT;
    if( getInstance().user != null ) {
      result = Model.findSent( getInstance().user );
    }
    return result;
  }
  
  public static IUser[] findReceived() {
    IUser[] result = EMPTY_RESULT;
    if( getInstance().user != null ) {
      result = Model.findReceived( getInstance().user );
    }
    return result;
  }
  
  public static IUser[] findInContact() {
    IUser[] result = EMPTY_RESULT;
    if( getInstance().user != null ) {
      result = Model.findInContact( getInstance().user );
    }
    return result;
  }

  public static IUser[] search( final SearchCriterias criterias ) {
    IUser[] result = EMPTY_RESULT;
    if( getInstance().user != null ) {
      result = Model.search( getInstance().user, criterias );
    }
    return result;
  }

  public void setCurrentUser( final IUser user ) {
    this.user = user;
    SessionModelListener[] lsnrs = new SessionModelListener[ listeners.size() ];
    listeners.toArray( lsnrs );
    for( int i = 0; i < lsnrs.length; i++ ) {
      lsnrs[ i ].loginChanged( user );
    }
  }
  
  public IUser getCurrentUser() {
    return user;
  }
  
  public void addSessionModelListener( final SessionModelListener listener ) {
    listeners.add( listener );
  }
  
  public void removeSessionModelListener( final SessionModelListener listener ){
    listeners.remove( listener );
  }

  public void save( IUser user ) {
    Model.save( user );
  }
}
