/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH. All rights
 * reserved. This program and the accompanying materials are made available
 * under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors: Innoopract Informationssysteme GmbH - initial API and
 * implementation
 ******************************************************************************/
package org.platforms.contest.ui;

import org.eclipse.rap.jface.action.*;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.ui.IWorkbenchWindow;
import org.eclipse.rap.ui.entrypoint.ActionBarAdvisor;
import org.eclipse.rap.ui.entrypoint.IActionBarConfigurer;
import org.platforms.contest.ui.actions.*;

public class DefaultActionBarAdvisor extends ActionBarAdvisor {

  private Action login;
  private Action regAction;
  private Action tttAction;
  private Action helpAction;

  public DefaultActionBarAdvisor( final IActionBarConfigurer configurer ) {
    super( configurer );
  }

  protected void makeActions( final IWorkbenchWindow window ) {
    login = new Login();
    register( login );
    regAction = new RegisterAction();
    register( regAction );
    tttAction = new TttAction();
    register( tttAction );
    helpAction = new HelpAction();
    register( helpAction );
  }

  protected void fillMenuBar( final IMenuManager menuBar ) {
    MenuManager user = new MenuManager( "User", "user" );
    menuBar.add( user );
    user.add( login );
    user.add( regAction );
    user.add( tttAction );
    MenuManager help = new MenuManager( "Help", "help" );
    menuBar.add(  help );
    help.add( helpAction );
  }
  
  protected void fillCoolBar( final ICoolBarManager coolBar ) {
    IToolBarManager toolbar = new ToolBarManager( RWT.FLAT | RWT.RIGHT );
    coolBar.add( new ToolBarContributionItem( toolbar, "user" ) );
    toolbar.add( login );
    toolbar.add( regAction );
    toolbar.add( tttAction );
    toolbar.add( helpAction );
  }
}
