/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.ui;

import org.eclipse.rap.jface.viewers.*;
import org.eclipse.rap.rwt.widgets.Composite;
import org.eclipse.rap.ui.part.ViewPart;
import org.platforms.contest.core.model.IUser;
import org.platforms.contest.middle.SessionModel;
import org.platforms.contest.middle.SessionModelListener;
import org.platforms.contest.ui.status.*;


public class ViewContact extends ViewPart {

  private static class TreeContentProvider implements ITreeContentProvider {

    private static final Object[] EMPTY_RESULT = new Object[ 0 ];

    public Object[] getChildren( final Object parentElement ) {
      Object[] result = EMPTY_RESULT;
      if( parentElement instanceof RCDSent ) {
        result = SessionModel.findSent();
      } else if( parentElement instanceof RCDReceived ) {
        result = SessionModel.findReceived();
      } else if( parentElement instanceof RCDInContact ) {
        result = SessionModel.findInContact();
      }
      return result;
    }

    public Object getParent( final Object element ) {
      return null;
    }

    public boolean hasChildren( final Object element ) {
      return getChildren( element ).length > 0;
    }

    public Object[] getElements( final Object inputElement ) {
      return new Object[] {
        new CurrentUser(),
        new RCDInContact(),
        new RCDSent(),
        new RCDReceived()
      };
    }

    public void dispose() {
    }

    public void inputChanged( final Viewer viewer, 
                              final Object oldInput, 
                              final Object newInput )
    {
    }
  }

  private class TreeLabelProvider extends LabelProvider {
    public String getText( Object element ) {
      String result;
      if( element instanceof IType ) {
        result = ( ( IType )element ).getText();
      } else if( element instanceof IUser ) {
        result = ( ( IUser )element ).getFullname();
      } else {
        result = element.toString();
      }
      return result;
    }
  }
  
  public void createPartControl( final Composite parent ) {
    final TreeViewer viewer = new TreeViewer( parent );
    viewer.setContentProvider( new TreeContentProvider() );
    viewer.setLabelProvider( new TreeLabelProvider() );
    viewer.setInput( this );
    getSite().setSelectionProvider( viewer );
    SessionModel.getInstance().addSessionModelListener( new SessionModelListener() {
      public void loginChanged( final IUser user ) {
        viewer.refresh();
      }
    } );

  }
}
