/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.ui;

import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.browser.Browser;
import org.eclipse.rap.rwt.events.SelectionEvent;
import org.eclipse.rap.rwt.events.SelectionListener;
import org.eclipse.rap.rwt.graphics.Color;
import org.eclipse.rap.rwt.layout.*;
import org.eclipse.rap.rwt.widgets.*;
import org.eclipse.rap.ui.*;
import org.eclipse.rap.ui.part.ViewPart;


public class ViewIntro extends ViewPart {

  public void createPartControl( final Composite parent ) {
    parent.setLayout( new FormLayout() );
    Color white = Display.getCurrent().getSystemColor( RWT.COLOR_WHITE );
    parent.setBackground( white );
    
    final Button start = new Button( parent, RWT.PUSH );
    start.setText( "start" );
    start.addSelectionListener( new SelectionListener() {
      public void widgetSelected( final SelectionEvent event ) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IViewReference ref 
          = page.findViewReference( "org.platforms.contest.ui.intro" );
        page.toggleZoom( ref );
        start.setVisible( false );
        ref = page.findViewReference( "org.platforms.contest.ui.search" );
        IViewPart part = ref.getView( true );
        page.activate( part );
        ref = page.findViewReference( "org.platforms.contest.ui.contact" );
        part = ref.getView( true );
        page.activate( part );
      }
    } );
    FormData startData = new FormData();
    start.setLayoutData( startData );
    startData.top = new FormAttachment( 100, -35 );
    startData.left = new FormAttachment( 70, 0 );
    startData.right = new FormAttachment( 100, -5 );
    startData.bottom = new FormAttachment( 100, -10 );
    
    Browser browser = new Browser( parent, RWT.NONE );
    browser.setUrl( "intro/intro.html" );
    FormData browserData = new FormData();
    browser.setLayoutData( browserData );
    browserData.top = new FormAttachment( 0, 0 );
    browserData.left = new FormAttachment( 0, 0 );
    browserData.right = new FormAttachment( 100, 0 );
    browserData.bottom = new FormAttachment( start, -5 );
  }
}
