/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.ui;

import java.text.MessageFormat;
import org.eclipse.rap.jface.viewers.*;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.custom.SashForm;
import org.eclipse.rap.rwt.custom.ScrolledComposite;
import org.eclipse.rap.rwt.events.SelectionEvent;
import org.eclipse.rap.rwt.events.SelectionListener;
import org.eclipse.rap.rwt.graphics.*;
import org.eclipse.rap.rwt.layout.*;
import org.eclipse.rap.rwt.widgets.*;
import org.eclipse.rap.ui.part.ViewPart;
import org.platforms.contest.core.model.IUser;
import org.platforms.contest.middle.SessionModel;
import org.platforms.contest.middle.SessionModelListener;


public class ViewSearch extends ViewPart {


  private static final int SEARCH_ITEM_WIDTH = 300;
  private static final int SEARCH_ITEM_HEIGHT = 22;
  private TableViewer viewer;
  private Composite tableHolder;

  private class TableContentProvider
    implements IStructuredContentProvider
  {

    public Object[] getElements( final Object inputElement ) {
      return SessionModel.search( null );
    }

    public void dispose() {
    }

    public void inputChanged( final Viewer viewer, 
                              final Object oldInput, 
                              final Object newInput )
    {
    }
  }

  private class TableLabelProvider 
    extends LabelProvider
    implements ITableLabelProvider
  {

    public Image getColumnImage( final Object element, 
                                 final int columnIndex )
    {
      return null;
    }

    public String getColumnText( final Object element, 
                                 final int columnIndex )
    {
      String result = "";
      switch( columnIndex ) {
        case 0:
          result = ( ( IUser )element ).getFullname();
        break;
        case 1:
          result = ( ( IUser )element ).getTown();
        break;
        case 2:
          result = ( ( IUser )element ).getCountry();
        break;
        default:
          String txt = "Column index {0} does not exist";
          Object[] param = new Object[] { new Integer( columnIndex ) };
          String msg = MessageFormat.format( txt, param );
          throw new IllegalArgumentException( msg );
      }
      return result;
    }
  }

  public void createPartControl( final Composite parent ) {
    SashForm sashForm = new SashForm( parent, RWT.HORIZONTAL );
    Composite search = new Composite( sashForm, RWT.NONE );
    Composite result = new Composite( sashForm, RWT.NONE );
    sashForm.setWeights( new int[]{
      45, 
      55
    } );
    Color white = Display.getCurrent().getSystemColor( RWT.COLOR_WHITE );
    search.setBackground( white );
    result.setBackground( white );
    
    createSearchCriteria( search );
    createSearchResult( result );
    
    SessionModel model = SessionModel.getInstance();
    model.addSessionModelListener( new SessionModelListener() {
      public void loginChanged( final IUser user ) {
        if( user == null ) {
          createTable( tableHolder );
        }
      }
    } );
  }

  private void createSearchResult( final Composite parent ) {
    parent.setLayout( new FormLayout() );
    
    Label title = new Label( parent, RWT.NONE );
    title.setText( "Search Result:" );
    Font oldFont = title.getFont();
    Font newFont = Font.getFont( oldFont.getName(), 13, oldFont.getStyle() );
    title.setFont( newFont );
    FormData titleData = new FormData();
    title.setLayoutData( titleData );
    titleData.top = new FormAttachment( 0, 5 );
    titleData.left = new FormAttachment( 0, 5 );
    titleData.right = new FormAttachment( 100, -5 );
    titleData.bottom = new FormAttachment( 0, 30 );
    
    Label lblAxisChoice = new Label( parent, RWT.NONE );
    lblAxisChoice.setText( "Select axis representation:" );
    FormData lblAxisChoiceData = new FormData();
    lblAxisChoice.setLayoutData( lblAxisChoiceData );
    lblAxisChoiceData.top = new FormAttachment( title, 5 );
    lblAxisChoiceData.left = new FormAttachment( 0, 5 );
    lblAxisChoiceData.right = new FormAttachment( 45, 0 );
    lblAxisChoiceData.bottom = new FormAttachment( 0, 25 );
    
    Combo axisChoice = new Combo( parent, RWT.BORDER );
    axisChoice.setItems( new String[] { "E-I", "S-N" } );
    FormData axisChoiceData = new FormData();
    axisChoice.setLayoutData( axisChoiceData  );
    axisChoiceData.top = new FormAttachment( title, 5 );
    axisChoiceData.left = new FormAttachment( 80, 0 );
    axisChoiceData.right = new FormAttachment( 100, -5 );
    axisChoiceData.bottom = new FormAttachment( 0, 55 );
    
    Button sendRCD = new Button( parent, RWT.PUSH );
    sendRCD.setText( "send RCD" );
    FormData sendRCDData = new FormData();
    sendRCD.setLayoutData( sendRCDData );
    sendRCDData.top = new FormAttachment( 100, -30 );
    sendRCDData.left = new FormAttachment( 70, 0 );
    sendRCDData.right = new FormAttachment( 100, -5 );
    sendRCDData.bottom = new FormAttachment( 100, -5 );

    tableHolder = new Composite( parent, RWT.NONE );
    tableHolder.setLayout( new FillLayout() );
    FormData tableHolderData = new FormData();
    tableHolder.setLayoutData( tableHolderData );
    tableHolderData.top = new FormAttachment( sendRCD, -150 );
    tableHolderData.bottom = new FormAttachment( sendRCD, -5 );
    tableHolderData.left = new FormAttachment( 0, 5 );
    tableHolderData.right = new FormAttachment( 100, -5 );
    createTable( tableHolder );
    
    Composite content = new Composite( parent, RWT.NONE );
    Color gray = Display.getCurrent().getSystemColor( RWT.COLOR_GRAY );
    content.setBackground( gray );
    FormData contentData = new FormData();
    content.setLayoutData( contentData );
    contentData.top = new FormAttachment( axisChoice, 5 );
    contentData.left = new FormAttachment( 0, 5 );
    contentData.right = new FormAttachment( 100, -5 );
    contentData.bottom = new FormAttachment( tableHolder, -5 );
  }

  private Table createTable( final Composite parent ) {
    if( viewer != null ) {
      IContentProvider oldProvider = viewer.getContentProvider();
      if( oldProvider != null ) {
        oldProvider.dispose();
      }
      viewer.getTable().dispose();
    }

    viewer = new TableViewer( parent );
    Table table = viewer.getTable();
    
    TableColumn fullName = new TableColumn( table, RWT.NONE );
    fullName.setText( "Fullname" );
    fullName.setWidth( 120 );

    TableColumn town = new TableColumn( table, RWT.NONE );
    town.setText( "Town" );
    town.setWidth( 120 );
    
    TableColumn country = new TableColumn( table, RWT.NONE );
    country.setText( "Country" );
    country.setWidth( 120 );
    
    String[] header = new String[] { "Fullname", "Town", "Country" };
    viewer.setColumnProperties( header );
    
    viewer.setContentProvider( new TableContentProvider() );
    viewer.setLabelProvider( new TableLabelProvider() );
    viewer.setInput( this );
    tableHolder.layout();

    return table;
  }

  private void createSearchCriteria( final Composite parent ) {
    parent.setLayout( new FormLayout() );
    
    Label title = new Label( parent, RWT.NONE );
    title.setText( "Please enter the search criterias:" );
    Font oldFont = title.getFont();
    Font newFont = Font.getFont( oldFont.getName(), 13, oldFont.getStyle() );
    title.setFont( newFont );
    FormData titleData = new FormData();
    title.setLayoutData( titleData );
    titleData.top = new FormAttachment( 0, 5 );
    titleData.left = new FormAttachment( 0, 5 );
    titleData.right = new FormAttachment( 100, -5 );
    titleData.bottom = new FormAttachment( 0, 30 );
    
    Button search = new Button( parent, RWT.PUSH );
    search.setText( "search" );
    search.addSelectionListener( new SelectionListener() {
      public void widgetSelected( final SelectionEvent event ) {
        createTable( tableHolder );
      }
    } );
    FormData searchData = new FormData();
    search.setLayoutData( searchData );
    searchData.top = new FormAttachment( 100, -30 );
    searchData.left = new FormAttachment( 70, 0 );
    searchData.right = new FormAttachment( 100, -5 );
    searchData.bottom = new FormAttachment( 100, -5 );
    
    int style = RWT.V_SCROLL | RWT.H_SCROLL;
    ScrolledComposite scroller = new ScrolledComposite( parent, style );
    FormData scrollerData = new FormData();
    scroller.setLayoutData( scrollerData );
    scrollerData.top = new FormAttachment( title, 5 );
    scrollerData.left = new FormAttachment( 0, 5 );
    scrollerData.right = new FormAttachment( 100, -5 );
    scrollerData.bottom = new FormAttachment( search, -5 );
    
    Composite content = new Composite( scroller, RWT.NONE );
    scroller.setContent( content );
    Label lblStatusRelated = new Label( content, RWT.NONE );
    lblStatusRelated.setText( "Select only members who" );
    Button notYetContacts = new Button( content, RWT.CHECK );
    notYetContacts.setText( "are not yet contacts of mine" );
    
    Control[] children = content.getChildren();
    for( int i = 0; i < children.length; i++ ) {
      children[ i ].setBounds( 0, 
                               SEARCH_ITEM_HEIGHT * i,
                               SEARCH_ITEM_WIDTH,
                               SEARCH_ITEM_HEIGHT );
    }
    content.setBounds( 0, 
                       0, 
                       SEARCH_ITEM_WIDTH, 
                       SEARCH_ITEM_HEIGHT * children.length );
  }
}
