/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.ui;

import org.eclipse.rap.jface.viewers.ISelection;
import org.eclipse.rap.jface.viewers.IStructuredSelection;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.graphics.Color;
import org.eclipse.rap.rwt.layout.*;
import org.eclipse.rap.rwt.widgets.*;
import org.eclipse.rap.ui.*;
import org.eclipse.rap.ui.part.ViewPart;
import org.platforms.contest.core.model.IUser;
import org.platforms.contest.middle.SessionModel;
import org.platforms.contest.ui.status.CurrentUser;


public class ViewStatus extends ViewPart {

  private Label fullName;
  private Label mailAddr;
  private Label town;
  private Label country;
  private Label motto;
  
  public void createPartControl( final Composite parent ) {
    parent.setLayout( new FormLayout() );
    Color white = Display.getCurrent().getSystemColor( RWT.COLOR_WHITE );
    parent.setBackground( white );
    
    Label lblFullName = new Label( parent, RWT.NONE );
    lblFullName.setText( "Name:" );
    FormData lblFullNameData = new FormData();
    lblFullName.setLayoutData( lblFullNameData );
    lblFullNameData.top = new FormAttachment( 0, 5 );
    lblFullNameData.left = new FormAttachment( 0, 5 );
    lblFullNameData.right = new FormAttachment( 15, 0 );
    lblFullNameData.bottom = new FormAttachment( 0, 25 );
    
    int contentStyle = RWT.READ_ONLY | RWT.BORDER | RWT.FLAT;
    fullName = new Label( parent, contentStyle );
    fullName.setText( "" );
    FormData fullNameData = new FormData();
    fullName.setLayoutData( fullNameData );
    fullNameData.top = new FormAttachment( 0, 5 );
    fullNameData.left = new FormAttachment( lblFullName, 5 );
    fullNameData.right = new FormAttachment( 45, 0 );
    fullNameData.bottom = new FormAttachment( 0, 20 );    

    Label lblUserName = new Label( parent, RWT.NONE );
    lblUserName.setText( "Mail:" );
    FormData lblUserNameData = new FormData();
    lblUserName.setLayoutData( lblUserNameData );
    lblUserNameData.top = new FormAttachment( 0, 5 );
    lblUserNameData.left = new FormAttachment( fullName, 20 );
    lblUserNameData.right = new FormAttachment( 65, 0 );
    lblUserNameData.bottom = new FormAttachment( 0, 25 );
    
    mailAddr = new Label( parent, contentStyle );
    mailAddr.setText( "" );
    FormData mailAddrData = new FormData();
    mailAddr.setLayoutData( mailAddrData );
    mailAddrData.top = new FormAttachment( 0, 5 );
    mailAddrData.left = new FormAttachment( lblUserName, 5 );
    mailAddrData.right = new FormAttachment( 100, -5 );
    mailAddrData.bottom = new FormAttachment( 0, 20 );    
    
    Label lblTown = new Label( parent, RWT.NONE );
    lblTown.setText( "Town:" );
    FormData lblTownData = new FormData();
    lblTown.setLayoutData( lblTownData );
    lblTownData.top = new FormAttachment( lblFullName, 5 );
    lblTownData.left = new FormAttachment( 0, 5 );
    lblTownData.right = new FormAttachment( 15, 0 );
    lblTownData.bottom = new FormAttachment( 0, 25 );
    
    town = new Label( parent, contentStyle );
    town.setText( "" );
    FormData townData = new FormData();
    town.setLayoutData( townData );
    townData.top = new FormAttachment( lblFullName, 5 );
    townData.left = new FormAttachment( lblTown, 5 );
    townData.right = new FormAttachment( 45, 0 );
    townData.bottom = new FormAttachment( lblFullName, 40 );    

    Label lblCountry = new Label( parent, RWT.NONE );
    lblCountry.setText( "Country:" );
    FormData lblCountryData = new FormData();
    lblCountry.setLayoutData( lblCountryData );
    lblCountryData.top = new FormAttachment( lblFullName, 5 );
    lblCountryData.left = new FormAttachment( town, 20 );
    lblCountryData.right = new FormAttachment( 65, 0 );
    lblCountryData.bottom = new FormAttachment( 0, 25 );
    
    country = new Label( parent, contentStyle );
    country.setText( "" );
    FormData countryData = new FormData();
    country.setLayoutData( countryData );
    countryData.top = new FormAttachment( lblFullName, 5 );
    countryData.left = new FormAttachment( lblCountry, 5 );
    countryData.right = new FormAttachment( 100, -5 );
    countryData.bottom = new FormAttachment( lblFullName, 40 );

    Label lblMotto = new Label( parent, RWT.NONE );
    lblMotto.setText( "Motto:" );
    FormData lblMottoData = new FormData();
    lblMotto.setLayoutData( lblMottoData );
    lblMottoData.top = new FormAttachment( lblTown, 35 );
    lblMottoData.left = new FormAttachment( 0, 5 );
    lblMottoData.right = new FormAttachment( 15, 0 );
    lblMottoData.bottom = new FormAttachment( lblTown, 75 );
    
    motto = new Label( parent, contentStyle );
    FormData mottoData = new FormData();
    motto.setLayoutData( mottoData );
    mottoData.top = new FormAttachment( lblTown, 35 );
    mottoData.left = new FormAttachment( lblMotto, 5 );
    mottoData.right = new FormAttachment( 100, -5 );
    mottoData.bottom = new FormAttachment( lblTown, 75 );
    createSelectionListener();
  }
  
  private void createSelectionListener() {
    IWorkbench workbench = PlatformUI.getWorkbench();
    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
    ISelectionService selectionService = window.getSelectionService();
    selectionService.addSelectionListener( new ISelectionListener() {
      public void selectionChanged( final IWorkbenchPart part, 
                                    final ISelection selection ) 
      {
        IStructuredSelection ss = ( IStructuredSelection )selection;
        fullName.setText( "" );
        mailAddr.setText( "" );
        country.setText( "" );
        town.setText( "" );
        motto.setText( "" );
        if( ss.getFirstElement() instanceof CurrentUser ) {
          IUser currentUser = SessionModel.getInstance().getCurrentUser();
          if( currentUser != null ) {
            fullName.setText( currentUser.getFullname()
                              + " ("
                              + currentUser.getLoginName()
                              + ")" );
            mailAddr.setText( currentUser.getEMail() );
            country.setText( currentUser.getCountry() );
            town.setText( currentUser.getTown() );
            motto.setText( currentUser.getMotto() );
          }
        } else if( ss.getFirstElement() instanceof IUser ) {
          IUser user = ( IUser )ss.getFirstElement();
          fullName.setText( user.getFullname()
                            + " ("
                            + user.getLoginName()
                            + ")" );
          mailAddr.setText( user.getEMail() );
          country.setText( user.getCountry() );
          town.setText( user.getTown() );
          motto.setText( user.getMotto() );
        }
      } 
    } );
  }

}
