/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.ui.actions;

import org.eclipse.rap.jface.action.Action;
import org.eclipse.rap.jface.resource.ImageDescriptor;
import org.eclipse.rap.rwt.widgets.Display;
import org.eclipse.rap.ui.plugin.AbstractUIPlugin;
import org.platforms.contest.ui.dialogs.LoginDialog;
import org.platforms.contest.core.model.IUser;
import org.platforms.contest.middle.SessionModel;

public class Login extends Action {
  
  public Login() {
    setId( Login.class.getName() );
    setText( "Login/Logoff" );
    ImageDescriptor image 
      = AbstractUIPlugin.imageDescriptorFromPlugin( "org.platforms.contest.ui", 
                                                    "icons/login.gif" );
    setImageDescriptor( image );
  }
  
  public void run() {
    final SessionModel model = SessionModel.getInstance();
    if( model.getCurrentUser() == null ) {
      final LoginDialog loginDialog = new LoginDialog( Display.getCurrent() );
      loginDialog.setTitle( "Login" );
      loginDialog.setMessage( "Please submit your username and password." );
      loginDialog.setCallback( new Runnable() {
        public void run() {
          String username = loginDialog.getUsername();
          String password = loginDialog.getPassword();
          IUser user = SessionModel.findByLoginName( username );
          if( user == null ) {
            loginDialog.setMessage( "No user with that name exists." );
          } else if ( ! password.equals( user.getPassword() ) ) {
            loginDialog.setMessage( "Password wrong." );
          } else {
            model.setCurrentUser( user );
            loginDialog.close();
          }
        }
      } );
      loginDialog.open();
    } else {
      // logoff
      model.setCurrentUser( null );
      // TODO refresh UI
    }
  }
}
