/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.ui.actions;

import org.eclipse.rap.jface.action.Action;
import org.eclipse.rap.jface.resource.ImageDescriptor;
import org.eclipse.rap.rwt.widgets.Display;
import org.eclipse.rap.ui.plugin.AbstractUIPlugin;
import org.platforms.contest.core.model.IUser;
import org.platforms.contest.middle.SessionModel;
import org.platforms.contest.ui.dialogs.RegistrationDialog;

public class RegisterAction extends Action {
  
  public RegisterAction() {
    setId( RegisterAction.class.getName() );
    // TODO change text depending on whether a user is logged on
    setText( "Register" );
    ImageDescriptor image 
      = AbstractUIPlugin.imageDescriptorFromPlugin( "org.platforms.contest.ui", 
                                                    "icons/register.gif" );
    setImageDescriptor( image );
  }
  
  public void run() {
    final RegistrationDialog regDialog =
                               new RegistrationDialog( Display.getCurrent() );
    final SessionModel model = SessionModel.getInstance();
    if( model.getCurrentUser() != null ) {
      regDialog.setTitle( "Change User Data" );
      regDialog.setUser( model.getCurrentUser() );
    } else {
      regDialog.setTitle( "Register" );
    }
    regDialog.setCallback( new Runnable() {
      public void run() {
        IUser user = regDialog.getUser();
        if( user != null ) {
          setText( "Change User Data" );
        }
      }
    } );
    regDialog.open();
  }
}
