/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.ui.actions;

import java.io.IOException;
import org.eclipse.rap.jface.action.Action;
import org.eclipse.rap.jface.resource.ImageDescriptor;
import org.eclipse.rap.rwt.widgets.Display;
import org.eclipse.rap.ui.plugin.AbstractUIPlugin;
import org.platforms.contest.core.model.IUser;
import org.platforms.contest.middle.SessionModel;
import org.platforms.contest.ui.dialogs.TttDialog;

public class TttAction extends Action {
  
  public TttAction() {
    setId( TttAction.class.getName() );
    setText( "Take the Temperament Test" );
    ImageDescriptor image 
      = AbstractUIPlugin.imageDescriptorFromPlugin( "org.platforms.contest.ui", 
                                                    "icons/ttt.gif" );
    setImageDescriptor( image );
  }
  
  public void run() {
    final TttDialog tttDialog;
    IUser user = SessionModel.getInstance().getCurrentUser();
    if( user != null ) {
      try {
        tttDialog = new TttDialog( Display.getCurrent() );
        tttDialog.setCallback( new Runnable() {
          public void run() {
            tttDialog.close();
          }
        } );
        tttDialog.open();
      } catch( IOException e ) {
        // TODO Problem reading the questions file
        e.printStackTrace();
      }
    }
  }
}
