/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.ui.dialogs;

import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.events.SelectionAdapter;
import org.eclipse.rap.rwt.events.SelectionEvent;
import org.eclipse.rap.rwt.layout.GridData;
import org.eclipse.rap.rwt.layout.GridLayout;
import org.eclipse.rap.rwt.widgets.*;
import org.platforms.contest.core.model.IUser;
import org.platforms.contest.core.model.ModelObjectFactory;
import org.platforms.contest.middle.SessionModel;

public class RegistrationDialog {

  private static final int STYLE = RWT.DIALOG_TRIM
                                 | RWT.APPLICATION_MODAL
                                 | RWT.RESIZE;
  private final Shell shell;
  private Label mesgLabel;
  private Text userText;
  private Text pass1Text;
  private Text pass2Text;
  private Text nameText;
  private Text mailText;
  private Text townText;
  private Combo countryCombo;
  private Text mottoText;
  private Button submitButton;
  private Runnable callback;
  private IUser user;

  public RegistrationDialog( final Shell parent ) {
    shell = new Shell( parent, STYLE );
    create();
  }

  public RegistrationDialog( final Display display ) {
    shell = new Shell( display, STYLE );
    create();
  }

  private void create() {
    GridLayout gridLayout = new GridLayout();
    gridLayout.numColumns = 2;
    shell.setBounds( 100, 100, 400, 400 );
    shell.setLayout( gridLayout );
    // label layout data
    GridData labelData = new GridData();
    labelData.widthHint = 90;
    labelData.heightHint = 20;
    labelData.verticalAlignment = GridData.CENTER;
    // text layout data
    GridData textData = new GridData( GridData.FILL_HORIZONTAL );
    textData.heightHint = 20;
    mesgLabel = new Label( shell, RWT.NONE );
    mesgLabel.setText( "Please enter your personal data below." );
    GridData data = new GridData();
    data.horizontalAlignment = GridData.CENTER;
    data.verticalAlignment = GridData.CENTER;
    data.horizontalSpan = 2;
    data.widthHint = 280;
    data.heightHint = 25;
    mesgLabel.setLayoutData( data );
    // name label and input field
    Label nameLabel = new Label( shell, RWT.NONE );
    nameLabel.setText( "Your Name:" );
    nameLabel.setLayoutData( labelData );
    nameText = new Text( shell, RWT.BORDER );
    nameText.setLayoutData( textData );
    // mailaddr label and input field
    Label mailLabel = new Label( shell, RWT.NONE );
    mailLabel.setText( "Email Address:" );
    mailLabel.setLayoutData( labelData );
    mailText = new Text( shell, RWT.BORDER );
    mailText.setLayoutData( textData );
    // town label and input field
    Label townLabel = new Label( shell, RWT.NONE );
    townLabel.setText( "Town:" );
    townLabel.setLayoutData( labelData );
    townText = new Text( shell, RWT.BORDER );
    townText.setLayoutData( textData );
    // country label and input field
    // TODO [rst] turn into a combobox
    Label countryLabel = new Label( shell, RWT.NONE );
    countryLabel.setText( "Country:" );
    countryLabel.setLayoutData( labelData );
//    countryText = new Text( shell, RWT.BORDER );
//    countryText.setLayoutData( textData );
    countryCombo = new Combo( shell, RWT.NONE );
    // TODO list of countries
    countryCombo.add( "France" );
    countryCombo.add( "Germany" );
    countryCombo.add( "Hungary" );
    countryCombo.add( "Italy" );
    // workaround: needed for selection
    countryCombo.addSelectionListener( new SelectionAdapter() {} );
    countryCombo.setLayoutData( textData );
    // life motto label and input field
    Label mottoLabel = new Label( shell, RWT.NONE );
    mottoLabel.setText( "Life Motto:" );
    mottoLabel.setLayoutData( labelData );
    mottoText = new Text( shell, RWT.BORDER | RWT.WRAP );
    GridData multiTextData = new GridData( GridData.FILL_HORIZONTAL );
    multiTextData.heightHint = 40;
    mottoText.setLayoutData( multiTextData );
    // user label and input field
    Label userLabel = new Label( shell, RWT.NONE );
    userLabel.setText( "Username:" );
    userLabel.setLayoutData( labelData );
    userText = new Text( shell, RWT.BORDER );
    userText.setLayoutData( textData );
    // password label and input field
    Label pass1Label = new Label( shell, RWT.NONE );
    pass1Label.setText( "Password:" );
    pass1Label.setLayoutData( labelData );
    pass1Text = new Text( shell, RWT.BORDER | RWT.PASSWORD );
    pass1Text.setLayoutData( textData );
    // password 2 label and input field
    Label pass2Label = new Label( shell, RWT.NONE );
    pass2Label.setText( "Retype Password:" );
    pass2Label.setLayoutData( labelData );
    pass2Text = new Text( shell, RWT.BORDER | RWT.PASSWORD );
    pass2Text.setLayoutData( textData );
    // submit button
    submitButton = new Button( shell, RWT.PUSH );
    submitButton.setText( "Submit" );
    // TODO
    // shell.setDefaultButton( submitButton );
    data = new GridData();
    data.horizontalAlignment = GridData.END;
    data.verticalAlignment = GridData.END;
    data.horizontalSpan = 2;
    data.widthHint = 100;
    data.heightHint = 25;
    submitButton.setLayoutData( data );
    submitButton.addSelectionListener( new SelectionAdapter() {
      public void widgetSelected( SelectionEvent e ) {
        submit();
      }
    } );
  }

  private void submit() {
    if (checkData()) {
      apply();
      callback.run();
      shell.close();
    }
  }
  
  private void apply() {
    if( user == null ) {
      user = ModelObjectFactory.createUser();
    }
    user.setFullname( getFullName() );
    user.setEMail( getMailAddr() );
    user.setTown( getTown() );
    user.setCountry( getCountry() );
    user.setMotto( getMotto() );
    user.setLoginName( getUsername() );
    user.setPassword( getPassword() );
    // TODO add other fields
    SessionModel model = SessionModel.getInstance();
    model.save( user );
  }

  private boolean checkData() {
    boolean result = true;
    if ( "".equals( getPassword() ) ) {
      mesg( "Please choose a password." );
      result = false;
    }
    // TODO check password strength, forbidden chars etc.
    if ( ! getPassword().equals( getPassword2() ) ) {
      mesg( "The passwords do not match." );
      result = false;
    }
    if ( "".equals( getUsername() ) ) {
      mesg( "Please choose a username for login." );
      result = false;
    }
    if ( "".equals( getMotto() )) {
      mesg( "Please enter your life motto." );
      result = false;
    }
    if ( "".equals( getCountry() ) ) {
      mesg( "Please select your country." );
      result = false;
    }
    if ( "".equals( getTown() ) ) {
      mesg( "Please enter your town." );
      result = false;
    }
    if ( "".equals( getMailAddr() ) ) {
      mesg( "Please enter your mailaddress." );
      result = false;
    }
    if ( "".equals( getFullName() ) ) {
      mesg( "Please enter your full name." );
      result = false;
    }
    return result;
  }

  // display warning
  private void mesg( String message ) {
    setMessage( message );
  }

  public void setCallback( final Runnable callback ) {
    this.callback = callback;
  }

  public void open() {
    shell.layout();
    shell.open();
  }

  public void close() {
    shell.close();
  }
  
  public void setUser( final IUser user ) {
    this.user = user;
  }

  public IUser getUser() {
    return user;
  }

  public void setMessage( final String message ) {
    mesgLabel.setText( message );
  }

  public void setTitle( final String title ) {
    shell.setText( title );
  }
  
  // Workaround:
  // Due to a bug in RAP, getText() sometimes returns the String "null"
  
  private String getFullName() {
    String result = nameText.getText();
    // TODO workaround for RAP bug, delete when fixed
    return "null".equals(result) ? "" : result.trim();
  }
  
  private String getMailAddr() {
    String result = mailText.getText();
    // TODO workaround for RAP bug, delete when fixed
    return "null".equals(result) ? "" : result.trim();
  }
  
  private String getTown() {
    String result = townText.getText();
    // TODO workaround for RAP bug, delete when fixed
    return "null".equals(result) ? "" : result.trim();
  }
  
  private String getCountry() {
//    String result = countryCombo.getText();
    String result = "";
    if ( countryCombo.getSelectionIndex() != -1) {
      result = countryCombo.getItem( countryCombo.getSelectionIndex() );
    }
    // TODO workaround for RAP bug, delete when fixed
    return "null".equals(result) ? "" : result.trim();
  }

  private String getMotto() {
    String result = mottoText.getText();
    // TODO workaround for RAP bug, delete when fixed
    return "null".equals(result) ? "" : result.trim();
  }
  
  private String getUsername() {
    String result = userText.getText();
    // TODO workaround for RAP bug, delete when fixed
    return "null".equals(result) ? "" : result.trim();
  }
  
  private String getPassword() {
    String result = pass1Text.getText();
    // TODO workaround for RAP bug, delete when fixed
    return "null".equals(result) ? "" : result.trim();
  }

  private String getPassword2() {
    String result = pass2Text.getText();
    // TODO workaround for RAP bug, delete when fixed
    return "null".equals(result) ? "" : result.trim();
  }
}
