/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.ui.dialogs;

import java.io.*;
import java.util.*;
import java.util.List;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.custom.ScrolledComposite;
import org.eclipse.rap.rwt.events.SelectionAdapter;
import org.eclipse.rap.rwt.events.SelectionEvent;
import org.eclipse.rap.rwt.layout.*;
import org.eclipse.rap.rwt.widgets.*;
import org.platforms.contest.core.model.*;
import org.platforms.contest.middle.SessionModel;

public class TttDialog {

  private static final String TTT_QUESTIONS_TXT = "ttt-questions.txt";
  private static final int STYLE = RWT.TITLE
                                 | RWT.APPLICATION_MODAL
                                 | RWT.RESIZE;
  private final Shell shell;
  private Label mesgLabel;
  private Runnable callback;
  private Button submitButton;
  private List questionComposites;
  private ScrolledComposite scrollerComp;
  private Composite headComp;
  private Composite footComp;

  static class Question {
    String question;
    String answer1;
    String answer2;
    int dimension;
    int value1;
    int value2;
  }
  
  static class QuestionComposite extends Composite {

    private final Question question;
    private Button button1;
    private Button button2;

    public QuestionComposite( Composite parent, Question question ) {
      super( parent, RWT.BORDER );
      this.question = question;
      GridLayout layout = new GridLayout();
      layout.numColumns = 1;
      setLayout( layout );
      GridData data = new GridData( GridData.FILL_HORIZONTAL );
      data.heightHint = 20;
      Label questionLabel = new Label( this, RWT.NONE );
      questionLabel.setText( question.question );
      questionLabel.setLayoutData( data );
      button1 = new Button( this, RWT.RADIO );
      button1.setText( question.answer1 );
      button1.setLayoutData( data );
      button2 = new Button( this, RWT.RADIO );
      button2.setText( question.answer2 );
      button2.setLayoutData( data );
      layout();
    }
    
    public int getDimension() {
      return question.dimension;
    }
    
    public int getChoice() {
      int result = 0;
      if( button1.getSelection() ) {
        result = question.value1;
      } else if( button2.getSelection() ) {
        result = question.value2;
      }
      return result;
    }
  }
  
  /**
   * @throws IOException if the questions file could not be read.
   */
  public TttDialog( final Shell parent ) throws IOException {
    shell = new Shell( parent, STYLE );
    create();
  }

  /**
   * @throws IOException if the questions file could not be read.
   */
  public TttDialog( final Display display ) throws IOException {
    shell = new Shell( display, STYLE );
    create();
  }

  private void create() throws IOException {
    List questions = readQuestions();
    
    shell.setBounds( 100, 100, 420, 600 );
    shell.setLayout( new FormLayout() );
    shell.setText( "Temperament Test" );

    // head composite
    headComp = new Composite( shell, RWT.NONE );
    FormData headData = new FormData();
    headData.top = new FormAttachment( 0, 5 );
    headData.right = new FormAttachment( 100, -5 );
    headData.bottom = new FormAttachment( 0, 30 );
    headData.left = new FormAttachment( 0, 5 );
    headComp.setLayoutData( headData );
    headComp.setLayout( new FillLayout() );
    mesgLabel = new Label( headComp, RWT.NONE );
    mesgLabel.setText( "Please answer the following questions." );

    //main composite
    scrollerComp = new ScrolledComposite( shell, RWT.V_SCROLL );
    FormData mainData = new FormData();
    mainData.top = new FormAttachment( 0, 30 );
    mainData.right = new FormAttachment( 100, -5 );
    mainData.bottom = new FormAttachment( 100, -30 );
    mainData.left = new FormAttachment( 0, 5 );
    scrollerComp.setLayoutData( mainData );
    
    // inner comp for questions
    Composite questComp = new Composite( scrollerComp, RWT.NONE );
    questionComposites = new ArrayList();
    int i = 0;
    int y = 0;
    for( Iterator iter = questions.iterator(); iter.hasNext(); ) {
      Question question = ( Question )iter.next();
      Composite composite = new QuestionComposite( questComp, question );
      composite.setBounds( 0, y, 380, 90 );
      questionComposites.add( composite );
      i++;
      y += 90;
    }
    questComp.setBounds( 0, 0, 380, y );
    scrollerComp.setContent( questComp );

    // foot composite
    footComp = new Composite( shell, RWT.NONE );
    FormData footData = new FormData();
    footData.top = new FormAttachment( 100, -30 );
    footData.right = new FormAttachment( 100, -5 );
    footData.bottom = new FormAttachment( 100, -5 );
    footData.left = new FormAttachment( 0, 5 );
    footComp.setLayoutData( footData );
    footComp.setLayout( new FormLayout() );

    submitButton = new Button( footComp, RWT.PUSH );
    submitButton.setText( "Submit" );
    FormData buttonData = new FormData();
    buttonData.top = new FormAttachment( 0 );
    buttonData.right = new FormAttachment( 100 );
    buttonData.bottom = new FormAttachment( 100 );
    buttonData.left = new FormAttachment( 100, -60 );
    submitButton.setLayoutData( buttonData );
    // TODO
    // shell.setDefaultButton( submitButton );
    submitButton.addSelectionListener( new SelectionAdapter() {
      public void widgetSelected( SelectionEvent e ) {
        submit();
      }
    } );
    
    Button cancelButton = new Button( footComp, RWT.NONE );
    cancelButton.setText( "Cancel" );
    FormData caButtonData = new FormData();
    caButtonData.top = new FormAttachment( 0 );
    caButtonData.right = new FormAttachment( 100, -70 );
    caButtonData.bottom = new FormAttachment( 100 );
    caButtonData.left = new FormAttachment( 100, -135 );
    cancelButton.setLayoutData( caButtonData );
    cancelButton.addSelectionListener( new SelectionAdapter() {
      public void widgetSelected(SelectionEvent event) {
        shell.setVisible( false );
      }
    } );
  }

  private void submit() {
    if( checkData() ) {
      if (callback != null) {
        callback.run();
      }
    }
  }
  
  public void setCallback( final Runnable callback ) {
    this.callback = callback;
  }

  public void open() {
    shell.layout();
    shell.open();
  }

  public void close() {
//    TODO: dispose problems
//    shell.close();
    shell.setVisible( false );
  }

  // TODO no checks for correct format yet
  static List readQuestions() throws IOException {
    InputStream stream = TttDialog.class.getResourceAsStream( TTT_QUESTIONS_TXT );
    BufferedReader reader = new BufferedReader( new InputStreamReader( stream ) );
    String line;
    int count = 0;
    ArrayList questions = new ArrayList();
    Question currQuestion = null;
    while(( line = reader.readLine() ) != null ) {
      count++;
      if( count == 1 ) {
        currQuestion = new Question();
        currQuestion.question = line.trim();
      } else if( count == 2 ) {
        currQuestion.answer1 = line.substring( 2 );
        currQuestion.dimension = getDimension( line.charAt( 0 ));
        currQuestion.value1 = getValue( line.charAt( 0 ));
      } else if( count == 3 ) {
        currQuestion.answer2 = line.substring( 2 );
        currQuestion.value2 = getValue( line.charAt( 0 ));
        questions.add( currQuestion );
      } else {
        count = 0;
      }
    }
    return questions;
  }
  
  static int getDimension( char c ) {
    int result = 0;
    if( c == 'E' || c == 'I' ) {
      result = ITTT.DIM_EI;
    } else if( c == 'S' || c == 'N' ) {
      result = ITTT.DIM_SN;
    } else if( c == 'T' || c == 'F' ) {
      result = ITTT.DIM_TF;
    } else if( c == 'J' || c == 'P' ) {
      result = ITTT.DIM_JP;
    }
    return result;
  }
  
  static int getValue( char c ) {
    int result = 0;
    if( c == 'E' || c == 'S' || c == 'T' || c == 'J' ) {
      result = 1;
    } else if( c == 'S' || c == 'N' || c == 'F' || c == 'P' ) {
      result = -1;
    }
    return result;
  }

  private boolean checkData() {
    boolean result = true;
    SessionModel model = SessionModel.getInstance();
    IUser currentUser = model.getCurrentUser();
    if( currentUser != null ) {
      ITTT ttt = currentUser.getTTT();
      if( ttt == null ) {
        ttt = ModelObjectFactory.createTTT( currentUser );
      } else {
        ttt.clear();
      }
      for( Iterator iter = questionComposites.iterator(); iter.hasNext(); ) {
        QuestionComposite tcomp = ( QuestionComposite )iter.next();
        ttt.add( tcomp.getDimension(), tcomp.getChoice() );
      }
      model.save( currentUser );
    } else {
      // sould not happen
      result = false;
    }
    return result;
  }
}
