/*******************************************************************************
 * Copyright (c) 2002-2006 Innoopract Informationssysteme GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Innoopract Informationssysteme GmbH - initial API and implementation
 ******************************************************************************/

package org.platforms.contest.ui.dialogs;

import java.util.List;
import org.platforms.contest.core.model.ITTT;
import org.platforms.contest.ui.dialogs.TttDialog.Question;
import junit.framework.TestCase;

public class TttDialog_Test extends TestCase {

  public void testReadFile() throws Exception {
    List questions = TttDialog.readQuestions();
    assertNotNull( questions );
    assertEquals( 40, questions.size() );
    Question q0 = ( Question )questions.get( 0 );
    Question q39 = ( Question )questions.get( 39 );
    assertEquals( "\"The whole is more than the sum of its parts\"", q0.question );
    assertEquals( "When confronted with a sketch of a great design of a building or machine", q39.question );
    assertEquals( "I am impressed and inspired", q39.answer1 );
    assertEquals( ITTT.DIM_SN, q0.dimension );
    assertEquals( "I'd rather see the final product", q39.answer2 );
    assertEquals( ITTT.DIM_SN, q39.dimension );
    assertEquals( -1, q39.value1 );
    assertEquals( +1, q39.value2 );
  }

}
